// TextureTransform.H: TextureTransform nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _TextureTransform_H_
#define _TextureTransform_H_

#include "xrml.H"

// utility includes
#include "transform.H"
// NOTE: add ", public transform" to parent class declaration
// end of utility includes

namespace xrml {
#define TextureTransformTypeId 	"TextureTransform"
extern bool IsTextureTransform(SFNode*);

class TextureTransform: public virtual SFNode, public transform {
private:
  //
  void clone_here(const TextureTransform&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    center_updated = 0x1,
    rotation_updated = 0x2,
    scale_updated = 0x4,
    translation_updated = 0x8 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  TextureTransform();
  TextureTransform(const TextureTransform&);
  TextureTransform& operator=(const TextureTransform&);
  virtual ~TextureTransform();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec2f          	center;
  SFFloat          	rotation;
  SFVec2f          	scale;
  SFVec2f          	translation;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_center(const SFVec2f&);
  void             	set_rotation(const SFFloat&);
  void             	set_scale(const SFVec2f&);
  void             	set_translation(const SFVec2f&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_center(const SFVec2f&);
  bool             	assign_rotation(const SFFloat&);
  bool             	assign_scale(const SFVec2f&);
  bool             	assign_translation(const SFVec2f&);
  
  // update status
  inline bool      	center_is_updated(void) { return (status & center_updated); }
  inline void      	center_clear_update(void) { status &= ~center_updated; }
  inline bool      	rotation_is_updated(void) { return (status & rotation_updated); }
  inline void      	rotation_clear_update(void) { status &= ~rotation_updated; }
  inline bool      	scale_is_updated(void) { return (status & scale_updated); }
  inline void      	scale_clear_update(void) { status &= ~scale_updated; }
  inline bool      	translation_is_updated(void) { return (status & translation_updated); }
  inline void      	translation_clear_update(void) { status &= ~translation_updated; }
  
  // utility members
  virtual void    	begin_render(void);
  virtual void    	end_render(void);

  // Transformation matrices for direction vectors (no translation,...)
  Mat4 xf_vec, inverse_xf_vec;
  
protected:
  void work_out(void), work_out_inverse(void);

  inline void util_init(void) { }
  inline void util_clone(const TextureTransform& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_TextureTransform_H_*/
