// TimeSensor.H: TimeSensor nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _TimeSensor_H_
#define _TimeSensor_H_

#include "xrml.H"
#include "TimeDependent.H"
#include "EnvironmentalSensor.H"
#include "Children.H"

// utility includes
// NOTE: assign_cycleInterval, assign_startTime, assign_stopTime are 
// non-standard and have been moved to the public source. Delete in 
// private source if regenerated (take care for changes!!)
// end of utility includes

namespace xrml {
#define TimeSensorTypeId 	"TimeSensor"
extern bool IsTimeSensor(SFNode*);

class TimeSensor: public virtual SFNode, public TimeDependent, public EnvironmentalSensor, public Children {
private:
  //
  void clone_here(const TimeSensor&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    cycleInterval_updated = 0x1,
    enabled_updated = 0x2,
    loop_updated = 0x4,
    startTime_updated = 0x8,
    stopTime_updated = 0x10,
    cycleTime_updated = 0x20,
    fraction_changed_updated = 0x40,
    isActive_updated = 0x80,
    time_updated = 0x100 
  };
  
protected:
  // raw eventOut posting:
  void post_cycleTime(void);
  void post_fraction_changed(void);
  void post_isActive(void);
  void post_time(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  TimeSensor();
  TimeSensor(const TimeSensor&);
  TimeSensor& operator=(const TimeSensor&);
  virtual ~TimeSensor();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFTime           	cycleInterval;
  SFBool           	enabled;
  //  SFBool           	loop;
  //  SFTime           	startTime;
  //  SFTime           	stopTime;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_cycleInterval(const SFTime&);
  void             	set_enabled(const SFBool&);
  void             	set_loop(const SFBool&);
  void             	set_startTime(const SFTime&);
  void             	set_stopTime(const SFTime&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_cycleInterval(const SFTime&);
  bool             	assign_enabled(const SFBool&);
  bool             	assign_loop(const SFBool&);
  bool             	assign_startTime(const SFTime&);
  bool             	assign_stopTime(const SFTime&);
  
  // eventOuts:
  SFTime            	cycleTime;
  void             	post_cycleTime(const SFTime& val);
  SFFloat            	fraction_changed;
  void             	post_fraction_changed(const SFFloat& val);
  //  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  SFTime            	time;
  void             	post_time(const SFTime& val);
  
  // update status
  inline bool      	cycleInterval_is_updated(void) { return (status & cycleInterval_updated); }
  inline void      	cycleInterval_clear_update(void) { status &= ~cycleInterval_updated; }
  inline bool      	enabled_is_updated(void) { return (status & enabled_updated); }
  inline void      	enabled_clear_update(void) { status &= ~enabled_updated; }
  inline bool      	loop_is_updated(void) { return (status & loop_updated); }
  inline void      	loop_clear_update(void) { status &= ~loop_updated; }
  inline bool      	startTime_is_updated(void) { return (status & startTime_updated); }
  inline void      	startTime_clear_update(void) { status &= ~startTime_updated; }
  inline bool      	stopTime_is_updated(void) { return (status & stopTime_updated); }
  inline void      	stopTime_clear_update(void) { status &= ~stopTime_updated; }
  inline bool      	cycleTime_is_updated(void) { return (status & cycleTime_updated); }
  inline void      	cycleTime_clear_update(void) { status &= ~cycleTime_updated; }
  inline bool      	fraction_changed_is_updated(void) { return (status & fraction_changed_updated); }
  inline void      	fraction_changed_clear_update(void) { status &= ~fraction_changed_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  inline bool      	time_is_updated(void) { return (status & time_updated); }
  inline void      	time_clear_update(void) { status &= ~time_updated; }
  
  // utility members
  bool should_be_active(void);
  void activate(void), deactivate(void);
  void sample(void);
  
protected:
  double current_cycle, previous_cycle, fraction;
  bool new_cycle(void);
  void set_cycle(double time);
  double cycle_start_time(void);
  bool waiting_to_become_active;

  void util_init(void);
  inline void util_clone(const TimeSensor& src) { util_init(); }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_TimeSensor_H_*/
