// TouchSensor.H: TouchSensor nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _TouchSensor_H_
#define _TouchSensor_H_

#include "xrml.H"
#include "PointingDeviceSensor.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define TouchSensorTypeId 	"TouchSensor"
extern bool IsTouchSensor(SFNode*);

class TouchSensor: public virtual SFNode, public PointingDeviceSensor, public Children {
private:
  //
  void clone_here(const TouchSensor&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    enabled_updated = 0x1,
    hitNormal_changed_updated = 0x2,
    hitPoint_changed_updated = 0x4,
    hitTexCoord_changed_updated = 0x8,
    isActive_updated = 0x10,
    isOver_updated = 0x20,
    touchTime_updated = 0x40 
  };
  
protected:
  // raw eventOut posting:
  void post_hitNormal_changed(void);
  void post_hitPoint_changed(void);
  void post_hitTexCoord_changed(void);
  void post_isActive(void);
  void post_isOver(void);
  void post_touchTime(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  TouchSensor();
  TouchSensor(const TouchSensor&);
  TouchSensor& operator=(const TouchSensor&);
  virtual ~TouchSensor();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFBool           	enabled;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_enabled(const SFBool&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_enabled(const SFBool&);
  
  // eventOuts:
  SFVec3f            	hitNormal_changed;
  void             	post_hitNormal_changed(const SFVec3f& val);
  SFVec3f            	hitPoint_changed;
  void             	post_hitPoint_changed(const SFVec3f& val);
  SFVec2f            	hitTexCoord_changed;
  void             	post_hitTexCoord_changed(const SFVec2f& val);
  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  SFBool            	isOver;
  void             	post_isOver(const SFBool& val);
  SFTime            	touchTime;
  void             	post_touchTime(const SFTime& val);
  
  // update status
  inline bool      	enabled_is_updated(void) { return (status & enabled_updated); }
  inline void      	enabled_clear_update(void) { status &= ~enabled_updated; }
  inline bool      	hitNormal_changed_is_updated(void) { return (status & hitNormal_changed_updated); }
  inline void      	hitNormal_changed_clear_update(void) { status &= ~hitNormal_changed_updated; }
  inline bool      	hitPoint_changed_is_updated(void) { return (status & hitPoint_changed_updated); }
  inline void      	hitPoint_changed_clear_update(void) { status &= ~hitPoint_changed_updated; }
  inline bool      	hitTexCoord_changed_is_updated(void) { return (status & hitTexCoord_changed_updated); }
  inline void      	hitTexCoord_changed_clear_update(void) { status &= ~hitTexCoord_changed_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  inline bool      	isOver_is_updated(void) { return (status & isOver_updated); }
  inline void      	isOver_clear_update(void) { status &= ~isOver_updated; }
  inline bool      	touchTime_is_updated(void) { return (status & touchTime_updated); }
  inline void      	touchTime_clear_update(void) { status &= ~touchTime_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const TouchSensor& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_TouchSensor_H_*/
