// Transform.H: Transform nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Transform_H_
#define _Transform_H_

#include "xrml.H"
#include "Transforming.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define TransformTypeId 	"Transform"
extern bool IsTransform(SFNode*);

class Transform: public virtual SFNode, public Transforming, public Children {
private:
  //
  void clone_here(const Transform&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    center_updated = 0x1,
    children_updated = 0x2,
    rotation_updated = 0x4,
    scale_updated = 0x8,
    scaleOrientation_updated = 0x10,
    translation_updated = 0x20,
    bboxCenter_updated = 0x40,
    bboxSize_updated = 0x80 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Transform();
  Transform(const Transform&);
  Transform& operator=(const Transform&);
  virtual ~Transform();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  SFVec3f          	center;
  //  array<Children*> 	children;
  //  SFRotation       	rotation;
  //  SFVec3f          	scale;
  //  SFRotation       	scaleOrientation;
  //  SFVec3f          	translation;
  //  SFVec3f          	bboxCenter;
  //  SFVec3f          	bboxSize;
  
  // eventIns:
  void             	addChildren(const MFNode&);
  void             	removeChildren(const MFNode&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_center(const SFVec3f&);
  void             	set_children(const MFNode&);
  void             	set_rotation(const SFRotation&);
  void             	set_scale(const SFVec3f&);
  void             	set_scaleOrientation(const SFRotation&);
  void             	set_translation(const SFVec3f&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_center(const SFVec3f&);
  bool             	assign_children(const MFNode&);
  bool             	assign_rotation(const SFRotation&);
  bool             	assign_scale(const SFVec3f&);
  bool             	assign_scaleOrientation(const SFRotation&);
  bool             	assign_translation(const SFVec3f&);
  bool             	assign_bboxCenter(const SFVec3f&);
  bool             	assign_bboxSize(const SFVec3f&);
  
  // update status
  inline bool      	center_is_updated(void) { return (status & center_updated); }
  inline void      	center_clear_update(void) { status &= ~center_updated; }
  inline bool      	children_is_updated(void) { return (status & children_updated); }
  inline void      	children_clear_update(void) { status &= ~children_updated; }
  inline bool      	rotation_is_updated(void) { return (status & rotation_updated); }
  inline void      	rotation_clear_update(void) { status &= ~rotation_updated; }
  inline bool      	scale_is_updated(void) { return (status & scale_updated); }
  inline void      	scale_clear_update(void) { status &= ~scale_updated; }
  inline bool      	scaleOrientation_is_updated(void) { return (status & scaleOrientation_updated); }
  inline void      	scaleOrientation_clear_update(void) { status &= ~scaleOrientation_updated; }
  inline bool      	translation_is_updated(void) { return (status & translation_updated); }
  inline void      	translation_clear_update(void) { status &= ~translation_updated; }
  inline bool      	bboxCenter_is_updated(void) { return (status & bboxCenter_updated); }
  inline void      	bboxCenter_clear_update(void) { status &= ~bboxCenter_updated; }
  inline bool      	bboxSize_is_updated(void) { return (status & bboxSize_updated); }
  inline void      	bboxSize_clear_update(void) { status &= ~bboxSize_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Transform& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Transform_H_*/
