// TransformP.C: Transform nodes (private source).
// Automatically generated with nodegen 0.5a - do not edit.

#include "Transform.H"
#include "xrmlP.H"

namespace xrml {
int Transform::major_version(void) { return 0; }
int Transform::minor_version(void) { return 5; }
bool Transform::is_leaf_class(void) { return true; }

bool IsTransform(SFNode* node)
{
  return (dynamic_cast<Transform*>(node) != 0);
}

static void process_Transform_addChildren(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "process_Transform_addChildren", "called for a non-Transform node");
  Transform_node->addChildren((const MFNode&)value);
}

static void process_Transform_removeChildren(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "process_Transform_removeChildren", "called for a non-Transform node");
  Transform_node->removeChildren((const MFNode&)value);
}

bool Transform::assign_center(const SFVec3f& value)
{
  // TODO: value range check!
  center = value;
  status |= center_updated;
  timestamp = interface[2]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_center(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_center", "called for a non-Transform node");
  return Transform_node->assign_center((const SFVec3f&)value);
}

void Transform::set_center(const SFVec3f& val)
{
  SFVec3f tmpval(val);
  fieldValue v(&tmpval);
  interface[2]->assign(this, v);
}

bool Transform::assign_children(const MFNode& value)
{
  MFNode oldval = _children;
  _children = value;
  if (checkValue(_children, IsChildren, "Transform.children", "Children")) {
    synchronize_children();
    status |= children_updated;
    timestamp = interface[3]->timestamp = world ? world->time : 0;
    return true;
  } else {
    _children = oldval;
    return false;
  }
}

static bool assign_Transform_children(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_children", "called for a non-Transform node");
  return Transform_node->assign_children((const MFNode&)value);
}

void Transform::set_children(const MFNode& val)
{
  MFNode tmpval(val);
  fieldValue v(&tmpval);
  interface[3]->assign(this, v);
}

bool Transform::assign_rotation(const SFRotation& value)
{
  // TODO: value range check!
  rotation = value;
  status |= rotation_updated;
  timestamp = interface[4]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_rotation(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_rotation", "called for a non-Transform node");
  return Transform_node->assign_rotation((const SFRotation&)value);
}

void Transform::set_rotation(const SFRotation& val)
{
  SFRotation tmpval(val);
  fieldValue v(&tmpval);
  interface[4]->assign(this, v);
}

bool Transform::assign_scale(const SFVec3f& value)
{
  // TODO: value range check!
  scale = value;
  status |= scale_updated;
  timestamp = interface[5]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_scale(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_scale", "called for a non-Transform node");
  return Transform_node->assign_scale((const SFVec3f&)value);
}

void Transform::set_scale(const SFVec3f& val)
{
  SFVec3f tmpval(val);
  fieldValue v(&tmpval);
  interface[5]->assign(this, v);
}

bool Transform::assign_scaleOrientation(const SFRotation& value)
{
  // TODO: value range check!
  scaleOrientation = value;
  status |= scaleOrientation_updated;
  timestamp = interface[6]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_scaleOrientation(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_scaleOrientation", "called for a non-Transform node");
  return Transform_node->assign_scaleOrientation((const SFRotation&)value);
}

void Transform::set_scaleOrientation(const SFRotation& val)
{
  SFRotation tmpval(val);
  fieldValue v(&tmpval);
  interface[6]->assign(this, v);
}

bool Transform::assign_translation(const SFVec3f& value)
{
  // TODO: value range check!
  translation = value;
  status |= translation_updated;
  timestamp = interface[7]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_translation(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_translation", "called for a non-Transform node");
  return Transform_node->assign_translation((const SFVec3f&)value);
}

void Transform::set_translation(const SFVec3f& val)
{
  SFVec3f tmpval(val);
  fieldValue v(&tmpval);
  interface[7]->assign(this, v);
}

bool Transform::assign_bboxCenter(const SFVec3f& value)
{
  // TODO: value range check!
  bboxCenter = value;
  status |= bboxCenter_updated;
  timestamp = interface[8]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_bboxCenter(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_bboxCenter", "called for a non-Transform node");
  return Transform_node->assign_bboxCenter((const SFVec3f&)value);
}

bool Transform::assign_bboxSize(const SFVec3f& value)
{
  // TODO: value range check!
  bboxSize = value;
  status |= bboxSize_updated;
  timestamp = interface[9]->timestamp = world ? world->time : 0;
  return true;
}

static bool assign_Transform_bboxSize(SFNode* node, const fieldValue& value)
{
  Transform* Transform_node = dynamic_cast<Transform*>(node);
  if (!Transform_node)
    Fatal(-1, "assign_Transform_bboxSize", "called for a non-Transform node");
  return Transform_node->assign_bboxSize((const SFVec3f&)value);
}

Transform::Transform()
{
  interfaceMember* the_interface[10] = {
    new eventIn("addChildren", tMFNode, process_Transform_addChildren),
    new eventIn("removeChildren", tMFNode, process_Transform_removeChildren),
    new exposedField("center", fieldValue(&center), assign_Transform_center),
    new exposedField("children", fieldValue(&_children), assign_Transform_children),
    new exposedField("rotation", fieldValue(&rotation), assign_Transform_rotation),
    new exposedField("scale", fieldValue(&scale), assign_Transform_scale),
    new exposedField("scaleOrientation", fieldValue(&scaleOrientation), assign_Transform_scaleOrientation),
    new exposedField("translation", fieldValue(&translation), assign_Transform_translation),
    new field("bboxCenter", fieldValue(&bboxCenter), assign_Transform_bboxCenter),
    new field("bboxSize", fieldValue(&bboxSize), assign_Transform_bboxSize),
  };
  SFNode::construct(TransformTypeId, 10, the_interface);

  center = SFVec3f(0,0,0);
  children = array<Children*>(0); 	_children = MFNode(0);
  rotation = SFRotation(0,0,1,0);
  scale = SFVec3f(1,1,1);
  scaleOrientation = SFRotation(0,0,1,0);
  translation = SFVec3f(0,0,0);
  bboxCenter = SFVec3f(0,0,0);
  bboxSize = SFVec3f(-1,-1,-1);
  
  Grouping::util_init();
  Transforming::util_init();
  Children::util_init();
  Transform::util_init();
}

void Transform::destruct(void)
{
  Transform::util_destruct();
  Transforming::util_destruct();
  Grouping::util_destruct();
  Children::util_destruct();
  SFNode::destruct();
}

Transform::~Transform()
{
  destruct();
}

void Transform::clone_here(const Transform& src)
{
  SFNode::clone(src);
  
  interface[2]->value = fieldValue(&center);
  interface[3]->value = fieldValue(&_children);
  interface[4]->value = fieldValue(&rotation);
  interface[5]->value = fieldValue(&scale);
  interface[6]->value = fieldValue(&scaleOrientation);
  interface[7]->value = fieldValue(&translation);
  interface[8]->value = fieldValue(&bboxCenter);
  interface[9]->value = fieldValue(&bboxSize);
  
  center = src.center;
  children = src.children;	  _children = src._children;
  rotation = src.rotation;
  scale = src.scale;
  scaleOrientation = src.scaleOrientation;
  translation = src.translation;
  bboxCenter = src.bboxCenter;
  bboxSize = src.bboxSize;
  
  Grouping::util_clone(src);
  Transforming::util_clone(src);
  Children::util_clone(src);
  Transform::util_clone(src);
}

Transform::Transform(const Transform& src)
{
  clone_here(src);
}

Transform& Transform::operator=(const Transform& src)
{
  if (this != &src) {
    destruct();
    clone_here(src);
  }
  return *this;
}

SFNode* Transform::instantiate(Proto *enclosing_proto)
{
  if (nameIndex>=0)
    // named node: return pointer to pre-made instance
    return enclosing_proto ? enclosing_proto->namedNodes[nameIndex] : this;
  
  Transform* instance = new Transform(*this);
  instance->instantiate_interface(enclosing_proto);
  instance->synchronize_children();
  return instance;
}

}  // namespace xrml
