// VisibilitySensor.H: VisibilitySensor nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _VisibilitySensor_H_
#define _VisibilitySensor_H_

#include "xrml.H"
#include "EnvironmentalSensor.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define VisibilitySensorTypeId 	"VisibilitySensor"
extern bool IsVisibilitySensor(SFNode*);

class VisibilitySensor: public virtual SFNode, public EnvironmentalSensor, public Children {
private:
  //
  void clone_here(const VisibilitySensor&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    center_updated = 0x1,
    enabled_updated = 0x2,
    size_updated = 0x4,
    enterTime_updated = 0x8,
    exitTime_updated = 0x10,
    isActive_updated = 0x20 
  };
  
protected:
  // raw eventOut posting:
  void post_enterTime(void);
  void post_exitTime(void);
  void post_isActive(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  VisibilitySensor();
  VisibilitySensor(const VisibilitySensor&);
  VisibilitySensor& operator=(const VisibilitySensor&);
  virtual ~VisibilitySensor();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec3f          	center;
  SFBool           	enabled;
  SFVec3f          	size;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_center(const SFVec3f&);
  void             	set_enabled(const SFBool&);
  void             	set_size(const SFVec3f&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_center(const SFVec3f&);
  bool             	assign_enabled(const SFBool&);
  bool             	assign_size(const SFVec3f&);
  
  // eventOuts:
  SFTime            	enterTime;
  void             	post_enterTime(const SFTime& val);
  SFTime            	exitTime;
  void             	post_exitTime(const SFTime& val);
  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  
  // update status
  inline bool      	center_is_updated(void) { return (status & center_updated); }
  inline void      	center_clear_update(void) { status &= ~center_updated; }
  inline bool      	enabled_is_updated(void) { return (status & enabled_updated); }
  inline void      	enabled_clear_update(void) { status &= ~enabled_updated; }
  inline bool      	size_is_updated(void) { return (status & size_updated); }
  inline void      	size_clear_update(void) { status &= ~size_updated; }
  inline bool      	enterTime_is_updated(void) { return (status & enterTime_updated); }
  inline void      	enterTime_clear_update(void) { status &= ~enterTime_updated; }
  inline bool      	exitTime_is_updated(void) { return (status & exitTime_updated); }
  inline void      	exitTime_clear_update(void) { status &= ~exitTime_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const VisibilitySensor& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_VisibilitySensor_H_*/
