/* Float.H */

#ifndef _XRML_FLOAT_H_
#define _XRML_FLOAT_H_

#include "memory.H"

namespace xrml {

#define EPSILON	1e-6

class Float: public PooledObj  {
  float x;
public:
  inline Float(const float xx =0.) { x = xx; }
  inline operator float() const { return x; }

  // returns minimum of 'this' and f
  inline const Float operator<<(const Float& f) const
  { return (x<f.x ? (*this) : f); }

  inline const Float& operator<<=(const Float& f) 
  { x = x<f.x ? x : f.x; return *this; }

  // returns maximum of 'this' and f
  inline const Float operator>>(const Float& f) const
  { return x>f.x ? (*this) : f; }

  inline const Float& operator>>=(const Float& f) 
  { x = x>f.x ? x : f.x; return *this; }

  inline bool operator==(const Float& f) const
  { return x==f.x; }

  inline bool operator!=(const Float& f) const
  { return x!=f.x; }

  // returns nonzero if 'this' is equal to zero within the tolerance
  inline bool operator|=(const Float& tolerance) const { return (x > -tolerance.x && x < tolerance.x); }
};

#ifndef HUGE
#define HUGE 1e72
#endif /*HUGE*/

}  // namespace xrml

#endif /*_XRML_FLOAT_H_*/
