/* complex.H: complex numbers, e.g. index of refraction */

#ifndef _XRML_COMPLEX_H_
#define _XRML_COMPLEX_H_

#include "memory.H"

namespace xrml {

class complex: public PooledObj  {
public:
  float r, i;

  inline complex(const float _r=0., const float _i=0.)
  {
    r = _r; i = _i;
  }

  inline bool operator==(const complex& c) const
  {
    return (r == c.r) && (i == c.i);
  }

  inline bool operator!=(const complex& c) const
  {
    return !(*this == c);
  }

  friend ostream& operator<<(ostream& s, const complex& c)
  {
    return s << c.r << "+" << c.i << "i" << "\n";
  }
};

}  // namespace xrml

#endif /*_XRML_COMPLEX_H_*/
