// vrml2_utf8_exporter: VRML'97 utf8 encoding exporter

#ifndef _VRML2_UTF8_EXPORTER_H_
#define _VRML2_UTF8_EXPORTER_H_

#include "../exporter.H"

namespace vrml2_utf8 {
  using namespace xrml;

class exporter: public xrml::exporter {
  int id;

  void save(class SFNode*);
  bool saved_already(class SFNode*);
  void mark_saved(class SFNode*);
  char *unique_nameId(class SFNode*);
  void save(const fieldValue& value);
  void save_link(class link* ref);
  void save_value(class field* field);
  bool save_value_or_link(class interfaceMember* ifm);
  void save(const SFBool& val);
  void save(const SFString& val);
  void save(const SFInt32& val);
  void save(const SFFloat& val);
  void save(const SFTime& val);
  void save(const SFVec2f& val);
  void save(const SFVec3f& val);
  void save(const SFColor& val);
  void save(const SFRotation& val);
  void save(const SFImage& val);
  void save_memberKind(class interfaceMember* ifm);
  void save_memberType(class interfaceMember* ifm);
  void save_proto_interfaceMember(class interfaceMember* ifm);
  void save_proto_interface(class Proto* proto);
  void save_proto_implementation(class Proto* proto);
  void save_protodef(class Proto* proto);
  void save_context(const MFNode* sceneGraph, const protoTable& protos);
  void save_route(class SFNode* srcNode, const char* srcId, class route* route);
  void save_routes(class SFNode* srcNode, const char* srcId, class routing_table* rtable);
  void save_routes(class SFNode* node);
  void save_routes(const MFNode& nodes);
  void save_children_routes(class  field* field);

public:
  exporter(class file* fh =0)
  {
    xrml::exporter::init(fh);
  }

  void save(class world* world);
};

}   // namespace vrml2_utf8

#endif /* _VRML2_UTF8_EXPORTER_H_ */
