// scanner.H: lexical scanner for vrml files

#ifndef _VRML2_UTF8_SCANNER_H_
#define _VRML2_UTF8_SCANNER_H_

#include <stdio.h>

#ifndef _VRML2_UTF8_SCANNER_SOURCE_
#define yyFlexLexer vrmlFlexLexer
#include "FlexLexer.h"
#endif

namespace vrml2_utf8 {
  using namespace xrml;

#include "tokens.H"

class scanner: public vrmlFlexLexer {
protected:
  FILE *scanfp;

  char** sbuf;
  char *sbufptr, *unputstr;
  int sbufsize;

  char *strsave(char *text);
  char *read_string(void);
  void new_string(void);
  void add_char(char c);

  YYSTYPE *lastvalp;
  int LexerInput(char *buf, int max_size);
  
public:
  scanner() {
    sbuf = 0;
    sbufptr = unputstr = 0;
    sbufsize = 0;
    lastvalp = 0;
    scanfp = 0;
  }

  int yylex(YYSTYPE *lvalp);

  void UnputString(char *s);
  void UnputToken(void);

  virtual void yyerror(char *s);
};

#ifdef _VRML_PARSER_SOURCE_
#undef YYSTYPE
#endif

} // namespace vrml2_utf8

#endif /* _VRML2_UTF8_SCANNER_H_ */
