dnl===========================================================================
dnl Copyright (c) 1998-2000 K.U.Leuven
dnl 
dnl This software is provided AS IS, without any express or implied
dnl warranty.  In no event will the authors or the K.U.Leuven be held
dnl liable for any damages or loss of profit arising from the use or
dnl non-fitness for a particular purpose of this software.
dnl 
dnl See file README in the home directory for details about
dnl copyrights and licensing.
dnl===========================================================================
dnl NAME:       acinclude
dnl TYPE:       m4 macro file
dnl PROJECT:    libvrml - An extensible VRML'97 parser
dnl CONTENT:    Additional definitions of autoconf macros
dnl===========================================================================
dnl AUTHORS:    jp      Jan Prikryl
dnl===========================================================================
dnl HISTORY:
dnl
dnl 30-Jan-00 20:35:21  jp      last modification
dnl 30-Jan-00 20:35:01  jp      added AC_FIND_MOTIF
dnl 28-Sep-99 19:55:39  jp      AC_CHECK_DEPGEN
dnl 10-Sep-99 20:33:51  jp      created
dnl===========================================================================
dnl
dnl This file is included in "aclocal.m4" by "aclocal"
dnl

dnl---------------------------------------------------------------------------
dnl `AC_FIND_OPENGL'
dnl
dnl Test for OpenGL/Mesa: If both are found and user specified --with-mesa, 
dnl Mesa library will be used (offscreen rendering). This code is based on
dnl the code from "3dom", see http://www.gv.kotnet.org/~kdf/3dom
dnl---------------------------------------------------------------------------
AC_DEFUN(AC_FIND_OPENGL, [
dnl Mesa test
  AC_ARG_WITH(mesa,
    [  --with-mesa             link against Mesa rather than OpenGL],
    [case "${withval}" in
      yes) mesa=true ;;
      no)  mesa=false ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --with-mesa) ;;
     esac],
    [mesa=false])
dnl We need X for this test
  AC_REQUIRE([AC_PATH_XTRA])
  AC_CHECK_LIB(Xmu, main)
dnl Normal OpenGL
  AC_CHECK_LIB(GL, glBegin, libgl=GL,, $X_LIBS -lXmu)
  if test -n "$libgl"; then
    AC_CHECK_LIB(GLU, gluPerspective,libglu=GLU,, $X_LIBS -l$libgl -lXmu)
  fi
  if test "$libgl$libglu" = "GLGLU" ; then
    have_opengl=yes
  fi 
dnl What about Mesa?
  AC_CHECK_LIB(MesaGL, glBegin, libmgl=MesaGL,, $X_LIBS -lXmu -lX11 -lXext)
  if test -n "$libmgl"; then
    AC_CHECK_LIB(MesaGLU, gluPerspective, libmglu=MesaGLU,,
                 $X_LIBS -l$libmgl -lXmu -lX11 -lXext)
  fi
  if test "$libmgl$libmglu" = "MesaGLMesaGLU" ; then
    have_mesa=yes
  fi 
dnl Test
  AC_MSG_CHECKING(which OpenGL libs to use)
  if test "x$have_opengl" = "x" -a "x$have_mesa" = "x" ; then
    AC_MSG_RESULT([OpenGL not available])
    AC_MSG_ERROR([cannot build the package without OpenGL])
  else
    if test "$have_opengl" -a "$have_mesa" -a "$mesa" = "true" \
            -o "x$have_opengl" = "x" ; then
      libgl=$libmgl
      libglu=$libmglu
    fi
    OPENGL_LIBS="-l$libgl -l$libglu"
    AC_MSG_RESULT($OPENGL_LIBS)
    AC_SUBST(OPENGL_LIBS)
  fi
])dnl

dnl---------------------------------------------------------------------------
dnl `AC_CHECK_DEPGEN'
dnl
dnl Check how dependencies shall be automatically generated. 
dnl Automake adds automatically `-Wp,MD,.deps/$(*F).P' to the compiler
dnl parameters, expecting the compiler to be GNU cc. This obviously won't 
dnl work on non-GNU systems. `-MDupdate .deps/$(*F).P' may work on IRIX
dnl (tested with MIPSpro 7.3.1m compiler). 
dnl---------------------------------------------------------------------------
AC_DEFUN(AC_CHECK_DEPGEN, [
  AC_MSG_CHECKING([how to generate dependencies automatically])
  dp_par=""
  dp_flag="false"
dnl Cache the results
  AC_CACHE_VAL(ac_cv_auto_deps,[
  dp_cflags=$CFLAGS
  dp_file=.deps$$
dnl GNU 
  CFLAGS="$dp_cflags -Wp,-MD,$dp_file"
  AC_TRY_COMPILE([#include <stdio.h>], [int i=0;],
    [dp_par='-Wp,-MD,.deps/\$\(\*F\).pp'
     dp_flag="true"])
dnl MIPSpro 
  if test x$dp_par = x ; then
    CFLAGS="$dp_cflags -MDupdate $dp_file" 
    AC_TRY_COMPILE([#include <stdio.h>], [int i=0;],
      [dp_par='-MDupdate\ .deps/\$\(\*F\).pp'
       dp_flag="true"])
  fi
dnl End of compiler tests
  if test -f $dp_file ; then
    rm $dp_file
  fi
  CFLAGS=$dp_cflags
  ac_cv_auto_deps="dp_flag=$dp_flag dp_par=$dp_par"])
dnl Output
  eval "$ac_cv_auto_deps"
  if test x$dp_flag = xfalse ; then
    dp_msg="not possible"
  else
    dp_msg="$dp_par"
  fi
  AC_MSG_RESULT($dp_msg)
  AUTODEP_PAR="$dp_par"
  AC_SUBST(AUTODEP_PAR)
  AM_CONDITIONAL(AM_AUTODEP, test x$dp_flag = xtrue)
])dnl

dnl---------------------------------------------------------------------------
dnl `AC_CHECK_PHBRML'
dnl
dnl Check whether there is the phbmrl library available; first, checks 
dnl the include and/or library directory has been specified. If not, try to
dnl find PhBRML package in subdirectory of the main package directory, and
dnl in the directory at the same level as the pacakge directory is.
dnl---------------------------------------------------------------------------
AC_DEFUN(AC_CHECK_PHBRML, [
  AC_MSG_CHECKING([for PhBML package])
  VRML_INC="not found"  
  VRML_LIB="not found"  
  pb_inc=""
  pb_lib=""
dnl Maybe there are some parameters to pay attention to
  AC_ARG_WITH(vrml-includes,
    [  --with-phbrml-includes=DIR
			PhBRML include files are in DIR],
    [if test -d $withval ; then
       AC_MSG_ERROR(bad value ${withval} for --with-vrml-includes)
     else
       pb_inc=${withval}
     fi])
  AC_ARG_WITH(vrml-libraries,
    [  --with-phbrml-libraries=DIR
			PhBRML library files are in DIR],
    [if test -d $withval ; then
       AC_MSG_ERROR(bad value ${withval} for --with-vrml-libraries)
     else
       pb_lib=${withval}
     fi])
dnl If user did not specify the directory, look for the packages in 
dnl "./VRML", "../VRML", and "${HOME}/VRML"- and cache the result, as 
dnl the test requires a CXX compile/link step
  if test x$pb_inc = x -o x$pb_lib = x ; then
    AC_CACHE_VAL(ac_cv_have_phbrml,[
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    pb_xcpp=$CPPFLAGS
    pb_xlibs=$LIBS
    for pb_base in . ./VRML/VRML ../VRML/VRML ${HOME}/VRML/VRML ; do
    if test -d $pb_base ; then
      CPPFLAGS="$pb_xcpp -I$pb_base -I$pb_base/NODES -I$pb_base/PhBRML"
      AC_TRY_CPP([
        #include <vrml.H>
        #include <nodeCatalog.H>
        #include <IndexedFaceSet.H>
        #include <PhBSurface.H>
        ],[pb_inc=$pb_base])
      if test x$pb_inc = x$pb_base ; then
        LIBS="$pb_xlibs -L$pb_base -lvrml"
        AC_TRY_LINK([#include <vrml.H>],
          [vrml_world *w = new vrml_world;
           if (w->parse(NULL)) w->newframe();],
          [pb_lib=$pb_base])
      fi
    fi
    done
    CPPFLAGS=$pb_xcpp
    LIBS=$pb_xlibs
    AC_LANG_RESTORE
    ac_cv_have_phbrml="pb_inc=$pb_inc pb_lib=$pb_lib"])
  fi
dnl Output
  eval "$ac_cv_have_phbrml"
  if test x$pb_inc != x ; then
    VRML_INC=$pb_inc
  fi
  if test x$pb_lib != x ; then
    VRML_LIB=$pb_inc
  fi
  AC_MSG_RESULT([includes $VRML_INC, libraries $VRML_LIB])
  if test x$pb_inc = x -o x$pb_lib = x ; then 
    AC_MSG_ERROR([VRML read will not compile without PhBRML library])
  fi
  AC_SUBST(VRML_INC)
  AC_SUBST(VRML_LIB)
])dnl

dnl---------------------------------------------------------------------------
dnl `AC_FIND_MOTIF'
dnl
dnl This macro is provided with the lessTif package. We are just including 
dnl the original code.
dnl---------------------------------------------------------------------------

dnl
dnl
dnl AC_FIND_MOTIF : find OSF/Motif or LessTif, and provide variables
dnl	to easily use them in a Makefile.
dnl
dnl Adapted from a macro by Andreas Zeller.
dnl
dnl The variables provided are :
dnl	link_motif		(e.g. -L/usr/lesstif/lib -lXm)
dnl	include_motif		(e.g. -I/usr/lesstif/lib)
dnl	motif_libraries		(e.g. /usr/lesstif/lib)
dnl	motif_includes		(e.g. /usr/lesstif/include)
dnl
dnl The link_motif and include_motif variables should be fit to put on
dnl your application's link line in your Makefile.
dnl
dnl Oleo CVS Id: motif.m4,v 1.9 1999/04/09 11:46:49 danny
dnl LessTif CVS $Id: acinclude.m4,v 1.1 2001/02/22 20:54:52 philippe Exp $
dnl
AC_DEFUN(AC_FIND_MOTIF,
[

AC_REQUIRE([AC_PATH_XTRA])

motif_includes=
motif_libraries=

dnl AC_ARG_WITH(motif,
dnl [  --without-motif         do not use Motif widgets])
dnl Treat --without-motif like
dnl --without-motif-includes --without-motif-libraries.
dnl if test "$with_motif" = "no"
dnl then
dnl   motif_includes=none
dnl   motif_libraries=none
dnl fi

AC_ARG_WITH(motif-includes,
[  --with-motif-includes=DIR    Motif include files are in DIR],
motif_includes="$withval")

AC_ARG_WITH(motif-libraries,
[  --with-motif-libraries=DIR   Motif libraries are in DIR],
motif_libraries="$withval")

AC_MSG_CHECKING(for Motif)

#
#
# Search the include files.
#
if test "$motif_includes" = ""; then
AC_CACHE_VAL(ac_cv_motif_includes,
[
ac_motif_save_LIBS="$LIBS"
ac_motif_save_INCLUDES="$INCLUDES"
ac_motif_save_CPPFLAGS="$CPPFLAGS"
ac_motif_save_LDFLAGS="$LDFLAGS"
#
LIBS="$X_PRE_LIBS -lXm -lXt -lX11 $X_EXTRA_LIBS $LIBS"
INCLUDES="$X_CFLAGS $INCLUDES"
CPPFLAGS="$X_CFLAGS $CPPFLAGS"
LDFLAGS="$X_LIBS $LDFLAGS"
#
ac_cv_motif_includes="none"
AC_TRY_COMPILE([#include <Xm/Xm.h>],[int a;],
[
# Xm/Xm.h is in the standard search path.
ac_cv_motif_includes=
],
[
# Xm/Xm.h is not in the standard search path.
# Locate it and put its directory in `motif_includes'
#
# /usr/include/Motif* are used on HP-UX (Motif).
# /usr/include/X11* are used on HP-UX (X and Athena).
# /usr/dt is used on Solaris (Motif).
# /usr/openwin is used on Solaris (X and Athena).
# Other directories are just guesses.
for dir in "$x_includes" "${prefix}/include" /usr/include /usr/local/include \
           /usr/include/Motif2.0 /usr/include/Motif1.2 /usr/include/Motif1.1 \
           /usr/include/X11R6 /usr/include/X11R5 /usr/include/X11R4 \
           /usr/dt/include /usr/openwin/include \
           /usr/dt/*/include /opt/*/include /usr/include/Motif* \
           "${prefix}"/*/include /usr/*/include /usr/local/*/include \
           "${prefix}"/include/* /usr/include/* /usr/local/include/*; do
if test -f "$dir/Xm/Xm.h"; then
ac_cv_motif_includes="$dir"
break
fi
done
])
#
LIBS="$ac_motif_save_LIBS"
INCLUDES="$ac_motif_save_INCLUDES"
CPPFLAGS="$ac_motif_save_CPPFLAGS"
LDFLAGS="$ac_motif_save_LDFLAGS"
])
motif_includes="$ac_cv_motif_includes"
fi
#
#
# Now for the libraries.
#
if test "$motif_libraries" = ""; then
AC_CACHE_VAL(ac_cv_motif_libraries,
[
ac_motif_save_LIBS="$LIBS"
ac_motif_save_INCLUDES="$INCLUDES"
ac_motif_save_CPPFLAGS="$CPPFLAGS"
ac_motif_save_LDFLAGS="$LDFLAGS"
#
LIBS="$X_PRE_LIBS -lXm -lXt -lX11 $X_EXTRA_LIBS $LIBS"
INCLUDES="$X_CFLAGS $INCLUDES"
CPPFLAGS="$X_CFLAGS $CPPFLAGS"
LDFLAGS="$X_LIBS $LDFLAGS"
#
ac_cv_motif_libraries="none"
AC_TRY_LINK([#include <Xm/Xm.h>],[XtToolkitInitialize();],
[
# libXm.a is in the standard search path.
ac_cv_motif_libraries=
],
[
# libXm.a is not in the standard search path.
# Locate it and put its directory in `motif_libraries'
#
# /usr/lib/Motif* are used on HP-UX (Motif).
# /usr/lib/X11* are used on HP-UX (X and Athena).
# /usr/dt is used on Solaris (Motif).
# /usr/lesstif is used on Linux (Lesstif).
# /usr/openwin is used on Solaris (X and Athena).
# Other directories are just guesses.
for dir in "$x_libraries" "${prefix}/lib" /usr/lib /usr/local/lib \
           /usr/lib/Motif2.0 /usr/lib/Motif1.2 /usr/lib/Motif1.1 \
           /usr/lib/X11R6 /usr/lib/X11R5 /usr/lib/X11R4 /usr/lib/X11 \
           /usr/dt/lib /usr/openwin/lib \
           /usr/dt/*/lib /opt/*/lib /usr/lib/Motif* \
           /usr/lesstif*/lib /usr/lib/Lesstif* \
           "${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
           "${prefix}"/lib/* /usr/lib/* /usr/local/lib/*; do
if test -d "$dir" && test "`ls $dir/libXm.* 2> /dev/null`" != ""; then
ac_cv_motif_libraries="$dir"
break
fi
done
])
#
LIBS="$ac_motif_save_LIBS"
INCLUDES="$ac_motif_save_INCLUDES"
CPPFLAGS="$ac_motif_save_CPPFLAGS"
LDFLAGS="$ac_motif_save_LDFLAGS"
])
#
motif_libraries="$ac_cv_motif_libraries"
fi
#
# Provide an easier way to link
#
if test "$motif_includes" = "none" -o "$motif_libraries" = "none"; then
        with_motif="no"
else
        with_motif="yes"
fi

if test "$with_motif" != "no"; then
        if test "$motif_libraries" = ""; then
                link_motif="-lXm"
                MOTIF_LIBS="-lXm"
        else
                link_motif="-L$motif_libraries -lXm"
                MOTIF_LIBS="-L$motif_libraries -lXm"
        fi
        if test "$motif_includes" != ""; then
                include_motif="-I$motif_includes"
                MOTIF_CFLAGS="-I$motif_includes"
        fi
	AC_DEFINE(HAVE_MOTIF)
else
        with_motif="no"
fi
#
AC_SUBST(link_motif)
AC_SUBST(include_motif)
AC_SUBST(MOTIF_CFLAGS)
AC_SUBST(MOTIF_LIBS)
#
#
#
motif_libraries_result="$motif_libraries"
motif_includes_result="$motif_includes"
test "$motif_libraries_result" = "" && motif_libraries_result="in default path"
test "$motif_includes_result" = "" && motif_includes_result="in default path"
test "$motif_libraries_result" = "none" && motif_libraries_result="(none)"
test "$motif_includes_result" = "none" && motif_includes_result="(none)"
AC_MSG_RESULT(
  [libraries $motif_libraries_result, headers $motif_includes_result])
])dnl

dnl---------------------------------------------------------------------------
dnl `CHECK_GNU_MAKE'
dnl
dnl This macro has been donwloaded from http://peti.cys.de/autoconf-archive/
dnl Some small chnges have been done.
dnl
dnl @author John Darrington <j.darrington@elvis.murdoch.edu.au>
dnl @version $Id: acinclude.m4,v 1.1 2001/02/22 20:54:52 philippe Exp $
dnl---------------------------------------------------------------------------
AC_DEFUN(CHECK_GNU_MAKE, [ 
  AC_MSG_CHECKING(for GNU make)
  AC_CACHE_VAL(_cv_gnu_make_command, [
    ifGNUmake=# ;
    _cv_gnu_make_command='' ;
dnl Search all the common names for GNU make
    for a in make gmake gnumake ; do
      if  ( $a --version 2> /dev/null | grep  -q GNU ) ; then
        _cv_gnu_make_command=$a ;
        ifGNUmake='' ;
      fi
    done
  ])
dnl Print a more menaingful message when no GNU make has been found
  res=$_cv_gnu_make_command
  if test x$res = x ; then
    res="not found"
  fi
  AC_MSG_RESULT($res)
  AC_SUBST(ifGNUmake)
])
dnl===========================================================================
dnl End of acincude.m4
dnl===========================================================================
