#!/bin/sh
## ===========================================================================
##  Copyright (c) 1994-2000 K.U.Leuven
##  
##  This software is provided AS IS, without any express or implied
##  warranty.  In no event will the authors or the K.U.Leuven be held
##  liable for any damages or loss of profit arising from the use or
##  non-fitness for a particular purpose of this software.
##  
##  See file 0README in the home directory of RenderPark for details about
##  copyrights and licensing.
## ===========================================================================
##  NAME:       mk2save
##  TYPE:       sh script
##  PROJECT:    Renderpark - Miscelaneous modules
##  CONTENT:    Saves original Makefiles
## ===========================================================================
##  AUTHORS:    jp      Jan Prikryl
## ===========================================================================
##  HISTORY:
##
##  09-Jan-00 17:56:30  jp      last modification
##  06-Sep-99 15:04:02  jp      created
## ===========================================================================
##
##  Originally, RenderPark was not built using GNU configue tools. If
##  you are using the original system of Makefiles and if you made
##  some changes, you may commit these changes using this script. Further
##  changes can be anytime reverted by calling "save2mk.sh".
##
mksv=`find . -name Makefile -print`
for i in $mksv ; do
    if test -f $i.save ; then
	if ! diff -c $i $i.save ; then
	    cp -i $i $i.save
	fi
    else
	cp $i $i.save
    fi
done

	

