#!/bin/sh
## ===========================================================================
##  Copyright (c) 1994-2000 K.U.Leuven
##  
##  This software is provided AS IS, without any express or implied
##  warranty.  In no event will the authors or the K.U.Leuven be held
##  liable for any damages or loss of profit arising from the use or
##  non-fitness for a particular purpose of this software.
##  
##  See file 0README in the home directory of RenderPark for details about
##  copyrights and licensing.
## ===========================================================================
##  NAME:       save2mk
##  TYPE:       sh script
##  PROJECT:    Renderpark - Miscelaneous modules
##  CONTENT:    Restores original Makefiles
## ===========================================================================
##  AUTHORS:    jp      Jan Prikryl
## ===========================================================================
##  HISTORY:
##
##  09-Jan-00 17:56:30  jp      last modification
##  06-Sep-99 14:53:38  jp      created
## ===========================================================================
##
##  Originally, RenderPark was not built using GNU configue tools. If
##  for some reason "configure" does not work for you, you may want to
##  try to restore the original RenderPark Makefiles and try to
##  compile the whole package using these.
##
mksv=`find . -name Makefile.save -print | sed 's/\.save//g'`
for i in $mksv ; do
    cp -f $i.save $i
done