// 2018.02.16 anl tests  based on embree 2.xx Sig17 presentation
// ==========================
// clang -std=c++11 -I./include/ embree-first.cpp build/libembree.so.2
 
#include <stdio.h>
#include <embree2/rtcore.h>
#include <embree2/rtcore_ray.h>

int main() {

    RTCDevice device = rtcNewDevice();
    RTCScene scene = rtcDeviceNewScene(device,RTC_SCENE_STATIC,RTC_INTERSECT1);

    // ADD GEOMETRY ===========================================
    // application  vertex  and  index  layout
    struct Vertex    {
        float  x,  y,  z,  s,  t;
    };
    struct Triangle  {
        int materialID,  v0,  v1,  v2;
    };
    int numVertices  = 4;
    int numTriangles = 2;
    Vertex  vertexPtr[] = { {0.25f, 0.25f, 0.f, 0.f, 0.f }, 
                            {1.f, 0.f, 0.f, 0.f, 0.f }, 
                            {0.f, 1.f, 0.f, 0.f, 0.f },
                            {.75f, .75f, .5f, 0.f, 0.f } };
    Triangle indexPtr[] = { {0,1,2}, {1,2,3} };
    int colors[] =        { 1,       2 };

    // add  mesh  to  scene
    unsigned int geomID = rtcNewTriangleMesh(scene, RTC_GEOMETRY_STATIC,
                          numTriangles,  numVertices,  1);
    // set  data  buffers
    rtcSetBuffer(scene,  geomID,  RTC_VERTEX_BUFFER,
                 vertexPtr,  0,  sizeof(Vertex));
    rtcSetBuffer(scene,  geomID,  RTC_INDEX_BUFFER,
                 indexPtr,   0,  sizeof(Triangle));
    rtcCommit(scene);

    // TRACE RAYS =============================================
    int width=20, height=20;
    int width1=width-1, height1=height-1;
    //struct Point { float x,y,z; };
    //Point p = {0.,0.,1.}, v={0.,0.,-1.};
    float pixels[width*height];

    //  loop  over  all  screen  pixels
    for (int y=0; y<height; y++) for (int x=0; x<width; x++) {
     
        //  create  and  trace  primary  ray
        RTCRay ray;//  =make_Ray(p, normalize(x*v.x+y*v.y+v.z), eps, inf);
    
        ray.geomID = RTC_INVALID_GEOMETRY_ID;    
        ray.org[0]=float(x)/width1;ray.org[1]=float(y)/height1;ray.org[2]=1;
        ray.dir[0]=0.;  ray.dir[1]=0.; ray.dir[2]=-1.; 
        ray.tnear =0.001f;  ray.tfar = 10000.f;
    
        rtcIntersect(scene,  ray);
        // Return: ray.geomID i ray.primId
    
        //  environment  shading
        if  (ray.geomID ==  RTC_INVALID_GEOMETRY_ID)  {
            pixels[y*width+x]  =  0.f;//make_Vec3f(0.0f);
            continue;
        } 
        //pixels[y*width+x] = 1.f;//make_Vec3f(0.0f);
        pixels[y*width+x] = colors[ray.primID];    
    }

    //  loop  over  all  screen  pixels  DISPLAY->PRINT
    for (int y=0; y<height; y++) for (int x=0; x<width; x++) {
        if (x==0) putchar('\n');
        printf("%1.f.", pixels[y*width+x]);
    }
    putchar('\n');    return 0;
}
