#ifndef AMATH_H
#define AMATH_H
/********************************************************************
 * BaseGLIB   Andrzej Lukaszewski
 *
 * Base
 *    
 *    AReal, ABool  + constants 
 *    ARand function [0,1]
 ********************************************************************/

#include <assert.h>
#include <math.h>
#include <stdlib.h>

typedef float         AReal;
typedef unsigned char ABool;

const AReal A_EPSILON = 0.00001;
const AReal APi       = M_PI;
const ABool Afalse    = 0;
const ABool Atrue     = 1;

inline ABool AClose(AReal a, AReal b){ return (fabs(a-b)<A_EPSILON); }
inline AReal ARand(){ return drand48(); }
#endif
