;; Wojciech Jedynak (wjedynak@gmail.com)

;; Part 01: Booleans and a reduction relation using general contexts

;;#lang racket
(require redex)

;; 1) language definition

(define-language B
  (e true
     false
     (or e e))
  (C hole
     (or C e)
     (or e C)))

;; 2) Examples of pattern maching

(redex-match B e (term (or true (or false true))))

(redex-match B C (term (or hole hole)))

(redex-match B C (term (or hole true)))

(redex-match B (in-hole C e) (term (or true false)))

(length (redex-match B (in-hole C e) (term (or true false))))

;; 3) A reduction relation

(define red
  (reduction-relation
   B
   (--> (in-hole C (or true e))
        (in-hole C true)
        "or-true")

   (--> (in-hole C (or false e))
        (in-hole C e)
        "or-false")))

;; 4) The reduction relation in action

(traces red (term (or true false)))

(traces red (term (or (or true false)
                      (or false true))))

(stepper red (term (or (or true false)
                       (or false true))))


;; Observation: an expression can be reduced in many steps
