(* control-prompt.sml *)
(* SML code of Section 10 of
     A Dynamic Continuation-Passing Style for Dynamic Delimited Continuations
   by D. Biernacki, O. Danvy, K. Millikin
   Version of 9 December 2014
*)

(* ********** *)

(* use "shift-reset.sml"; *)

signature CONTROL_AND_PROMPT
= sig
    type answer
    val control : (('a -> answer) -> answer) -> 'a
    val prompt : (unit -> answer) -> answer
    val run : (unit -> answer) -> answer
  end;

functor make_Control_and_Prompt (type answer) : CONTROL_AND_PROMPT
= struct
    type answer = answer
    
    datatype ans = ANS of trail1 -> answer
    withtype 'a cont1 = 'a -> ans and trail1 = answer cont1 list

    exception MISSING_PROMPT

    structure SR = make_Shift_and_Reset (type answer = ans)

    fun continue (ANS f) t1            (* continue : ans -> trail1 -> answer *)
        = f t1

    fun theta1 v                                    (* theta1 : answer cont1 *)
        = ANS (fn nil        => v
                | (k1 :: t1) => continue (k1 v) t1)

    fun control f              (* control : (('a -> answer) -> answer) -> 'a *)
        = SR.shift
            (fn k1 => ANS (fn t1 =>
               let val x = fn v =>
                             SR.shift
                               (fn k1' => ANS (fn t1' =>
                                  continue (k1 v) (t1 @ (k1' :: t1'))))
               in continue (SR.reset (fn () => theta1 (f x))) nil
               end)) handle MISSING_RESET => raise MISSING_PROMPT

    fun prompt c                      (* prompt : (unit -> answer) -> answer *)
        = continue (SR.reset (fn () => theta1 (c ()))) []

    fun run c                            (* run : (unit -> answer) -> answer *)
        = prompt c
  end;

(* ********** *)

(* end of control-prompt.sml *)
