(** implementation of the signature of the reduction semantics 
    for system T under CBN 

    M. Biernacka, June 15, 2007
*)

Require Export Main.
Require Export Apps.

Module Req <: RedSem.

 Inductive Rd': term -> term -> Prop :=
  | Rd'_beta : forall rho r s l, Rd' ((\rho,r;s);;l) ((sub r s);;l)
  | Rd'_succ : forall r s, Rd' r s -> Rd' (^r) (^s)
  | Rd'_app : forall r s t, Rd' r s -> Rd' (r;t) (s;t)
  | Rd'_R : forall rho r r' s t, Rd' r r' -> Rd' (R rho r s t) (R rho r' s t)
  | Rd'_Z : forall rho r s, Rd' (R rho Zero r s) r
  | Rd'_S : forall rho r s t, Rd' (R rho (^r) s t) ((t;r);R rho r s t).

 Hint Constructors Rd'.

 Definition Rd (rho:type) (r s:term) :=
  Rd' r s. 
 Hint Unfold Rd.

 Inductive RdTrans : type -> term -> term -> Prop :=
 | rd_refl : forall rho r, RdTrans rho r r
 | rd_trans : forall rho r s t, Rd rho r s -> 
   RdTrans rho s t ->
   RdTrans rho r t.	

 Inductive Val : type -> term -> Prop :=
 | val_zero : Val Int Zero
 | val_succ : forall r, Val Int r -> Val Int (^r)
 | val_lam : forall rho r sigma, Val (rho-->sigma) (\rho, r).

 Definition Ev (rho:type) (r s:term) : Prop :=
 (Val rho s) /\ RdTrans rho r s.

 Lemma ax_beta : 
   forall r s rho sigma rs,
     Rd sigma ((sub (\rho,r) rs);s) (sub r ((s::rs)#rs.(shift))).

 Proof.
  intros.
  unfold Rd in |- *.
  simpl in |- *.
  rewrite <- Sub_Sub_Ad_Hoc.
  exact (Rd'_beta rho _ _ nil).
 Qed.

 Lemma ax_ctx_app :
   forall r s t rho sigma, 
     Rd (rho-->sigma) r s -> Rd sigma (r;t) (s;t).
 
 Proof.
  induction 1.
  red in |- *.
  generalize (Rd'_beta rho0 r s (l ++ t :: nil)).
  do 2 rewrite <- apps_app.
  auto.
  repeat constructor; auto.
  repeat constructor; auto.
  repeat constructor; auto. 
  repeat constructor.
  repeat constructor.
Qed.

 Lemma ax_refl_trans_clo :
   forall r s t rho, 
     Rd rho r s -> Ev rho s t -> Ev rho r t.

 Proof.
   intros.
   destruct H0; split; auto.
   econstructor; eauto. 
 Qed.
 
 Lemma ax_lam_val : 
   forall r rho sigma,	 
     Ev (rho --> sigma) (\rho, r) (\rho, r). 	
 
 Proof.
  intros.
  split; auto.
  constructor.
  constructor.
 Qed.

 Lemma ax_zero_val :
   Ev Int Zero Zero.
 Proof.
 repeat constructor.
 Qed.

 Lemma ax_ev_succ :
   forall r s,
     Ev Int r s -> Ev Int (^r) (^s).

 Proof.
 intros.
 destruct H.
 split; auto.
 constructor; auto.
 induction H0.
 constructor.
 constructor 2 with (^s); auto.
 Qed.

 Lemma ax_ctx_r :
   forall rho r r' s t, 
     Rd Int r r' -> Rd rho (R rho r s t) (R rho r' s t).

 Proof.
 intros.
 constructor; auto.
 Qed.

 Lemma ax_zero_r :
   forall rho r s,
     Rd rho (R rho Zero r s) r.
 Proof.
 intros.
 constructor.
 Qed.  

 Lemma ax_succ_r :
   forall rho r s t,
     Rd rho (R rho (^r) s t) ((t;r);R rho r s t).  
 Proof.
 constructor.
 Qed.


End Req.


