Require Export Subst2.

(** Lists for coding typing contexts. First comes the type of [Var 0] *)

Definition context := list type.

(** *** Typing judgment. *)

(** An unsafe typing function : *) 

Fixpoint typ (rhos: context)(r:term) {struct r} : type := 
  match r with 
   | Zero => Int
   | ^ r => Int
   | [n] => nth n rhos dtype
   | r;s => arrow_right (typ rhos r)
   | \rho,r => rho --> typ (rho::rhos) r
   | R tau r s t => tau
  end.

(** A predicate checking whether the output of the previous typ is ok *)

Inductive CorTyp : context -> term -> Prop := 
  | CorZero : forall rhos, CorTyp rhos Zero
  | CorSucc : forall rhos r, CorTyp rhos r -> typ rhos r = Int -> CorTyp rhos (^r) 
  | CorVar : forall rhos n, n < length rhos -> CorTyp rhos [n]
  | CorApp : 
      forall rhos r s, CorTyp rhos r -> CorTyp rhos s -> 
        forall sigma, typ rhos r = ((typ rhos s) --> sigma) ->
           CorTyp rhos (r;s) 
  | CorAbs : forall rhos rho r, 
      CorTyp (rho::rhos) r -> CorTyp rhos (\rho,r)
  | CorR : forall rhos tau r s t, CorTyp rhos r -> CorTyp rhos s -> CorTyp rhos t ->
      typ rhos r = Int -> typ rhos s = tau -> typ rhos t = Int-->tau-->tau ->
      CorTyp rhos (R tau r s t).
Hint Constructors CorTyp.

Definition TypJ (rhos:context)(r:term)(rho:type) := 
  (CorTyp rhos r) /\ (typ rhos r = rho).

Hint Unfold TypJ.

(** Facts about TypJ *)

Lemma TypJ_Abs : forall rhos rho sigma mu r, 
  sigma = rho --> mu -> 
  TypJ (rho::rhos) r mu -> TypJ rhos (\rho,r) sigma.
Proof.
destruct 2; split; simpl; auto; congruence.
Qed.

Lemma TypJ_App : forall rhos rho sigma r s, 
 TypJ rhos r (rho-->sigma) -> TypJ rhos s rho -> TypJ rhos (r;s) sigma.
Proof.
do 2 destruct 1; split.
apply CorApp with sigma; auto; congruence.
simpl; rewrite H0; auto.
Qed.

Lemma TypJ_App_inv1 : forall rhos rho sigma r s, 
 TypJ rhos (r;s) rho -> sigma = typ rhos s ->
 TypJ rhos r (sigma-->rho).
Proof.
destruct 1; split; inversion_clear H; auto.
simpl in H0; rewrite H4 in H0; simpl in H0; congruence.
Qed.

Lemma TypJ_App_inv2 : forall rhos rho sigma r s, 
 TypJ rhos (r;s) rho -> sigma = typ rhos s -> TypJ rhos s sigma.
Proof.
destruct 1; split; inversion_clear H; auto.
Qed.
Hint Resolve TypJ_App TypJ_App_inv1 TypJ_App_inv2.

Lemma TypJ_ext_ctx : forall r rhos sigmas rho, 
  TypJ rhos r rho -> TypJ (rhos++sigmas) r rho.
Proof.
induction r; simpl; auto.
destruct 1; simpl; split.
inversion_clear H.
simpl; auto.
simpl in H0; auto.

destruct 1; simpl; split.
inversion_clear H;
simpl in H0;
subst rho;
constructor; auto;
elim (IHr rhos sigmas Int); intros; auto.
simpl; auto.

destruct 1; simpl in *; split.
inversion_clear H.
constructor; rewrite app_length; omega.
simpl; rewrite app_nth1; auto.
inversion_clear H; auto.

intros; elim H; intros.
inversion_clear H0.
simpl in H1.
rewrite H4 in H1; simpl in H1; subst.
elim (IHr2 rhos sigmas (typ rhos r2)); intros.
apply TypJ_App with (typ (rhos++sigmas) r2).
rewrite H1.
rewrite <- H4.
apply IHr1; split; auto.
rewrite H1.
apply IHr2; split; auto.
split; auto.

destruct 1; simpl in *; intros.
inversion_clear H.
elim (IHr (t::rhos) sigmas (typ (t::rhos) r)); [intros|split; auto].
split; auto.
simpl; subst; simpl in H2; rewrite H2; auto.

intros.
destruct H.
simpl in H0; subst.
inversion H; subst.
assert (TypJ rhos r1 Int).
split; auto.
assert (TypJ rhos r2 (typ rhos r2)).
split; auto.
assert (TypJ rhos r3 (Int-->typ rhos r2-->typ rhos r2)).
split; auto.
assert (h1:=IHr1 rhos sigmas Int H0).
assert (h2:=IHr2 rhos sigmas (typ rhos r2) H1).
assert (h3:=IHr3 rhos sigmas (Int-->typ rhos r2-->typ rhos r2) H2).
split; auto.
destruct h1; destruct h2; destruct h3; constructor; auto.
Qed.
Hint Resolve TypJ_ext_ctx.

(*Lemma TypJ_red_ctx : forall r rhos sigmas rho, 
  above (length rhos) r ->  
  TypJ (rhos++sigmas) r rho -> TypJ rhos r rho.
Proof.
induction r; unfold above; simpl; intros.
split; auto.
inversion_clear H0.
simpl in H2; simpl; auto.
inversion_clear H0.
simpl in H2; subst rho.
split; auto.
inversion_clear H1.
constructor; auto.
assert (TypJ rhos r Int).
apply IHr with sigmas; auto.
inversion_clear H1; auto.
assert (TypJ rhos r Int).
apply IHr with sigmas; auto.
inversion_clear H1; auto.

destruct (le_lt_dec (length rhos) n).
 generalize (H n l).
 destruct (eq_nat_dec n n); intuition; try discriminate.
destruct H0; simpl in *.
split; simpl; auto.
rewrite app_nth1 in H1; auto.

apply TypJ_App with (typ (rhos++sigmas) r2).
apply IHr1 with sigmas; eauto.
red; intros; destruct (orb_false_elim _ _ (H n H1)); auto.
apply IHr2 with sigmas; eauto.
red; intros; destruct (orb_false_elim _ _ (H n H1)); auto.

apply TypJ_Abs with (typ (t::rhos++sigmas) r).
inversion H0; auto.
apply IHr with sigmas; eauto.
red; simpl; intros; rewrite (S_pred n) with 0; intuition.
inversion H0; split; auto.
simpl; inversion H1; auto.

destruct H0.
simpl in H1; subst.
inversion H0; subst.
split; auto.
assert (above (length rhos) r1).
unfold above; intros.
destruct (orb_false_elim _ _ (H n H1)); auto. 
assert (above (length rhos) r2).
unfold above; intros.
destruct (orb_false_elim _ _ (H n H2)); auto. 
destruct (orb_false_elim _ _ H4); auto. 
assert (above (length rhos) r3).
unfold above; intros.
destruct (orb_false_elim _ _ (H n H3)); auto. 
destruct (orb_false_elim _ _ H7); auto. 
constructor; auto.
elim (IHr1 rhos sigmas Int H1); auto. 
elim (IHr2 rhos sigmas (typ (rhos++sigmas) r2) H2); auto. 
elim (IHr3 rhos sigmas (Int-->typ (rhos++sigmas) r2-->typ (rhos++sigmas) r2) H3); auto. 
elim (IHr1 rhos sigmas Int H1); auto. 
elim (IHr2 rhos sigmas (typ (rhos++sigmas) r2) H2); auto. 
elim (IHr3 rhos sigmas (Int-->typ (rhos++sigmas) r2-->typ (rhos++sigmas) r2) H3); auto. 
Qed.
*)

Lemma TypJ_up : forall r sigmas rhos rho sigma k, 
  length sigmas = k -> 
  TypJ (sigmas++rhos) r rho -> 
  TypJ (sigmas++sigma::rhos) (up k r) rho.
Proof. 
induction r; simpl; intros.
inversion_clear H0.
split; auto.
inversion_clear H0.
split; auto.
elim (IHr sigmas rhos rho sigma k H); intros; auto.
constructor; auto.
simpl in H2; congruence.
simpl in H2; split; auto.
subst rho.
inversion_clear H1; auto.
inversion_clear H1; congruence.

destruct H0; inversion_clear H0; simpl in *.
generalize H2; simpl_list; clear H2; intros.
rewrite H in H2.
simp.
split.
constructor.
simpl_list; simpl; omega.
simpl.
rewrite app_nth2.
rewrite H.
replace (S n - k) with (S (n-k)); try omega.
simpl.
rewrite app_nth2 in H1.
rewrite H in H1; auto.
omega.
omega.
rewrite app_nth1 in H1; auto; try omega.
apply TypJ_ext_ctx.
split.
constructor; auto.
omega.
simpl; auto.

eapply TypJ_App; eauto.

rename t into mu.
destruct H0; inversion_clear H0; simpl in *.
assert (TypJ ((mu::sigmas)++sigma::rhos) (up (S k) r) (typ (mu :: sigmas ++ rhos) r) ).
apply IHr; simpl; auto with arith.
destruct H0.
split; auto.
simpl in *; rewrite H3; auto.

destruct H0.
simpl in H1; subst.
inversion H0; subst.
assert (TypJ (sigmas++rhos) r1 Int).
split; auto.
assert (TypJ (sigmas++rhos) r2 (typ (sigmas++rhos) r2)).
split; auto.
assert (TypJ (sigmas++rhos) r3 (Int-->typ (sigmas++rhos) r2-->typ (sigmas++rhos) r2)).
split; auto.
split; auto.
constructor; auto.
elim IHr1 with sigmas rhos Int sigma (length sigmas); auto.
elim IHr2 with sigmas rhos (typ (sigmas++rhos) r2) sigma (length sigmas); auto.
elim IHr3 with sigmas rhos (Int-->typ (sigmas++rhos) r2-->typ (sigmas++rhos) r2) sigma (length sigmas); auto.
elim IHr1 with sigmas rhos Int sigma (length sigmas); auto.
elim IHr2 with sigmas rhos (typ (sigmas++rhos) r2) sigma (length sigmas); auto.
elim IHr3 with sigmas rhos (Int-->typ (sigmas++rhos) r2-->typ (sigmas++rhos) r2) sigma (length sigmas); auto.
Qed.

Lemma TypJ_sub2 : forall r sigmas rhos rho (rs:substitution),
 length rhos <= length rs -> 
 TypJ rhos r rho -> 
 (forall n d d', n<length rhos ->  
   TypJ sigmas (nth n rs d) (nth n rhos d')) ->  
 TypJ sigmas (sub r rs) rho. 
Proof. 
induction r.

simpl; intros; auto.
inversion_clear H0; auto.

simpl; intros.
inversion_clear H0; split; auto.
assert (TypJ sigmas (sub r rs) rho).
apply IHr with rhos; auto.
inversion_clear H2.
simpl in H3.
split; subst rho; auto.
constructor; auto.
inversion_clear H0; auto.
simpl in H3; inversion_clear H0; congruence. 

intros; simpl.
destruct H0. 
inversion_clear H0.
simpl in H2.
subst.
apply H1; auto.

intros.
simpl. 
eapply TypJ_App; eauto.

intros.
rename t into sigma.
simpl.
destruct H0.
inversion_clear H0.
simpl in H2.
set (mu := typ (sigma::rhos) r) in *.
assert (TypJ (sigma::sigmas) (sub r (sublift rs)) mu).
apply (IHr (sigma::sigmas) (sigma::rhos)); auto.
simpl; simpl_list; simpl; auto with arith.
intros; destruct n.
simpl. 
split; auto.
constructor; simpl; auto with arith.
simpl in H0; simpl.
rewrite nth_indep with (d':=up 0 d); simp; try omega.
replace (sigma :: sigmas) with (nil ++ (sigma :: sigmas)); auto.
apply TypJ_up; simpl; auto with arith.
eapply TypJ_Abs; eauto.

intros.
simpl.
destruct H0.
simpl in H2; subst.
inversion H0; subst.
split; auto.
constructor; auto.
elim IHr1 with sigmas rhos Int rs; auto.
elim IHr2 with sigmas rhos (typ rhos r2) rs; auto.
elim IHr3 with sigmas rhos (Int-->typ rhos r2-->typ rhos r2) rs; auto.
elim IHr1 with sigmas rhos Int rs; auto.
elim IHr2 with sigmas rhos (typ rhos r2) rs; auto.
elim IHr3 with sigmas rhos (Int-->typ rhos r2-->typ rhos r2) rs; auto.
Qed.
