type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type nat =
  | O
  | S of nat

type 'a sig0 = 'a
  (* singleton inductive, whose constructor was exist *)

type sumbool =
  | Left
  | Right

(** val plus : nat -> nat -> nat **)

let rec plus n m =
  match n with
    | O -> m
    | S p -> S (plus p m)

(** val minus : nat -> nat -> nat **)

let rec minus n m =
  match n with
    | O -> O
    | S k -> (match m with
                | O -> S k
                | S l -> minus k l)

type 'a list =
  | Nil
  | Cons of 'a * 'a list

(** val length : 'a1 list -> nat **)

let rec length = function
  | Nil -> O
  | Cons (a, m) -> S (length m)

(** val nth : nat -> 'a1 list -> 'a1 -> 'a1 **)

let rec nth n l default =
  match n with
    | O -> (match l with
              | Nil -> default
              | Cons (x, l') -> x)
    | S m ->
        (match l with
           | Nil -> default
           | Cons (x, t) -> nth m t default)

(** val map : ('a1 -> 'a2) -> 'a1 list -> 'a2 list **)

let rec map f = function
  | Nil -> Nil
  | Cons (a, t) -> Cons ((f a), (map f t))

(** val le_lt_dec : nat -> nat -> sumbool **)

let rec le_lt_dec n m =
  match n with
    | O -> Left
    | S n0 -> (match m with
                 | O -> Right
                 | S n1 -> le_lt_dec n0 n1)

(** val seq : nat -> nat -> nat list **)

let rec seq start = function
  | O -> Nil
  | S len0 -> Cons (start, (seq (S start) len0))

type type0 =
  | Int
  | Arrow of type0 * type0

type term =
  | Zero
  | Succ of term
  | Var of nat
  | App of term * term
  | Abs of type0 * term
  | R of type0 * term * term * term

(** val dtype : type0 **)

let dtype =
  Int

(** val arrow_right : type0 -> type0 **)

let arrow_right = function
  | Int -> dtype
  | Arrow (t, sigma0) -> sigma0

(** val type_dec : type0 -> type0 -> sumbool **)

let rec type_dec t s0 =
  match t with
    | Int -> (match s0 with
                | Int -> Left
                | Arrow (t0, t1) -> Right)
    | Arrow (t0, t1) ->
        (match s0 with
           | Int -> Right
           | Arrow (t2, t3) ->
               (match type_dec t0 t2 with
                  | Left -> type_dec t1 t3
                  | Right -> Right))

(** val up : nat -> term -> term **)

let rec up l = function
  | Zero -> Zero
  | Succ r0 -> Succ (up l r0)
  | Var n ->
      (match le_lt_dec l n with
         | Left -> Var (S n)
         | Right -> Var n)
  | App (r0, s) -> App ((up l r0), (up l s))
  | Abs (rho, r0) -> Abs (rho, (up (S l) r0))
  | R (tau, r0, s, t) -> R (tau, (up l r0), (up l s), (up l t))

type substitution = { support : term list; shift : nat }

(** val support : substitution -> term list **)

let support x = x.support

(** val shift : substitution -> nat **)

let shift x = x.shift

(** val sublift : substitution -> substitution **)

let sublift rs =
  { support = (Cons ((Var O), (map (up O) rs.support))); shift = (S
    rs.shift) }

(** val sub : term -> substitution -> term **)

let rec sub r rs =
  match r with
    | Zero -> Zero
    | Succ r0 -> Succ (sub r0 rs)
    | Var k ->
        nth k rs.support (Var (plus (minus k (length rs.support)) rs.shift))
    | App (r0, s) -> App ((sub r0 rs), (sub s rs))
    | Abs (rho, r0) -> Abs (rho, (sub r0 (sublift rs)))
    | R (tau, r0, s, t) -> R (tau, (sub r0 rs), (sub s rs), (sub t rs))

(** val id : nat -> substitution **)

let id k =
  { support = (map (fun x -> Var x) (seq O k)); shift = k }

type context = type0 list

(** val typ : context -> term -> type0 **)

let rec typ rhos = function
  | Zero -> Int
  | Succ r0 -> Int
  | Var n -> nth n rhos dtype
  | App (r0, s) -> arrow_right (typ rhos r0)
  | Abs (rho, r0) -> Arrow (rho, (typ (Cons (rho, rhos)) r0))
  | R (tau, r0, s, t) -> tau

type ('a, 'b) prod =
  | Pair of 'a * 'b

type 'b halfprod =
  'b
  (* singleton inductive, whose constructor was halfpair *)

module type RedSem = 
 sig 
  
 end

module NormalizationProof = 
 functor (R:RedSem) ->
 struct 
  type halts = term
  
  type coq_RR = __
  
  type coq_RRs = __
  
  (** val coq_RRs_nth : type0 list -> type0 -> term list -> term -> nat ->
                        coq_RRs -> coq_RR **)
  
  let rec coq_RRs_nth l rho rs r n =
    match l with
      | Nil -> Obj.magic (fun _ -> assert false (* absurd case *))
      | Cons (a, l0) ->
          (match rs with
             | Nil -> Obj.magic (fun _ -> assert false (* absurd case *))
             | Cons (t, rs0) -> (fun x ->
                 let Pair (x0, x1) = Obj.magic x in
                 (match n with
                    | O -> x0
                    | S n0 -> coq_RRs_nth l0 rho rs0 r n0 x1)))
  
  (** val coq_RR_implies_halt : type0 -> term -> coq_RR -> halts **)
  
  let rec coq_RR_implies_halt t r x =
    match t with
      | Int -> Obj.magic x
      | Arrow (t0, t1) -> let Pair (h, r0) = Obj.magic x in h
  
  (** val coq_Red_inv_preserves_RR : type0 -> term -> term -> coq_RR ->
                                     coq_RR **)
  
  let rec coq_Red_inv_preserves_RR t r s x =
    match t with
      | Int -> Obj.magic (Obj.magic x)
      | Arrow (t0, t1) ->
          Obj.magic (Pair ((let Pair (h, r0) = Obj.magic x in h),
            (fun s0 x0 ->
            let Pair (h, r0) = Obj.magic x in
            coq_Red_inv_preserves_RR t1 (App (r, s0)) (App (s, s0))
              (r0 s0 x0))))
  
  (** val coq_RedTrans_inv_preserves_RR : type0 -> term -> term -> coq_RR ->
                                          coq_RR **)
  
  let rec coq_RedTrans_inv_preserves_RR t r s x =
    match t with
      | Int -> Obj.magic (Obj.magic x)
      | Arrow (t0, t1) ->
          Obj.magic
            (let Pair (h, r0) = Obj.magic x in
            Pair (h, (fun s0 x0 ->
            coq_RedTrans_inv_preserves_RR t1 (App (r, s0)) (App (s, s0))
              (r0 s0 x0))))
  
  (** val coq_R_aux : term -> type0 -> term -> term -> term -> coq_RR ->
                      (halts, term -> halts halfprod -> (halts, term -> __ ->
                      __) prod halfprod) prod halfprod -> coq_RR **)
  
  let rec coq_R_aux t rho r s t0 x x0 =
    match t with
      | Zero -> coq_RedTrans_inv_preserves_RR rho (R (rho, r, s, t0)) s x
      | Succ t1 ->
          coq_RedTrans_inv_preserves_RR rho (R (rho, r, s, t0)) (App ((App
            (t0, t1)), (R (rho, t1, s, t0))))
            (let Pair (h, h0) = x0 in
            let Pair (h1, r0) = h0 t1 t1 in
            r0 (R (rho, t1, s, t0)) (coq_R_aux t1 rho t1 s t0 x x0))
      | Var n -> assert false (* absurd case *)
      | App (t1, t2) -> assert false (* absurd case *)
      | Abs (t1, t2) -> assert false (* absurd case *)
      | R (t1, t2, t3, t4) -> assert false (* absurd case *)
  
  (** val subst_preserves_RR : term -> substitution -> context -> type0 ->
                               coq_RRs -> coq_RR **)
  
  let rec subst_preserves_RR t rs rhos rho x =
    match t with
      | Zero -> Obj.magic Zero
      | Succ t0 ->
          Obj.magic (Succ
            (coq_RR_implies_halt Int (sub t0 rs)
              (subst_preserves_RR t0 rs rhos Int x)))
      | Var n ->
          coq_RRs_nth rhos dtype rs.support (Var
            (plus (minus n (length rs.support)) rs.shift)) n x
      | App (t0, t1) ->
          let sigma = typ rhos t1 in
          let Pair (h, r) =
            Obj.magic (subst_preserves_RR t0 rs rhos (Arrow (sigma, rho)) x)
          in
          r (sub t1 rs) (subst_preserves_RR t1 rs rhos sigma x)
      | Abs (t0, t1) ->
          Obj.magic (Pair ((Abs (t0, (sub t1 (sublift rs)))), (fun s x0 ->
            coq_Red_inv_preserves_RR (typ (Cons (t0, rhos)) t1) (App ((Abs
              (t0, (sub t1 (sublift rs)))), s))
              (sub t1 { support = (Cons (s, rs.support)); shift = rs.shift })
              (Obj.magic (fun rs0 rhos0 rho0 x1 _ ->
                subst_preserves_RR t1 rs0 rhos0 rho0 x1) { support = (Cons
                (s, rs.support)); shift = rs.shift } (Cons (t0, rhos))
                (typ (Cons (t0, rhos)) t1) (Pair (x0, x)) __))))
      | R (t0, t1, t2, t3) ->
          coq_R_aux (Obj.magic (subst_preserves_RR t1 rs rhos Int x)) rho
            (sub t1 rs) (sub t2 rs) (sub t3 rs)
            (subst_preserves_RR t2 rs rhos rho x)
            (Obj.magic (fun rs0 rhos0 rho0 x0 _ ->
              subst_preserves_RR t3 rs0 rhos0 rho0 x0) rs rhos (Arrow (Int,
              (Arrow (rho, rho)))) x __)
  
  (** val whnf : term -> type0 -> halts **)
  
  let whnf r rho =
    coq_RR_implies_halt rho r
      (subst_preserves_RR r (id O) Nil rho (Obj.magic __))
  
  type coq_Answer =
    | No
    | Yes of term
  
  (** val coq_Answer_rect : 'a1 -> (term -> 'a1) -> coq_Answer -> 'a1 **)
  
  let coq_Answer_rect f f0 = function
    | No -> f
    | Yes x -> f0 x
  
  (** val coq_Answer_rec : 'a1 -> (term -> 'a1) -> coq_Answer -> 'a1 **)
  
  let coq_Answer_rec f f0 = function
    | No -> f
    | Yes x -> f0 x
  
  (** val typ_dec : term -> context -> type0 -> sumbool **)
  
  let rec typ_dec t rhos rho =
    match t with
      | Zero -> (match rho with
                   | Int -> Left
                   | Arrow (t0, t1) -> Right)
      | Succ t0 ->
          (match typ_dec t0 rhos rho with
             | Left ->
                 (match rho with
                    | Int -> Left
                    | Arrow (t1, t2) -> Right)
             | Right -> Right)
      | Var n ->
          (match type_dec (nth n rhos dtype) rho with
             | Left ->
                 (match le_lt_dec (length rhos) n with
                    | Left -> Right
                    | Right -> Left)
             | Right -> Right)
      | App (t0, t1) ->
          (match typ_dec t1 rhos (typ rhos t1) with
             | Left -> typ_dec t0 rhos (Arrow ((typ rhos t1), rho))
             | Right -> Right)
      | Abs (t0, t1) ->
          (match rho with
             | Int -> Right
             | Arrow (t2, t3) ->
                 (match type_dec t0 t2 with
                    | Left -> typ_dec t1 (Cons (t0, rhos)) t3
                    | Right -> Right))
      | R (t0, t1, t2, t3) ->
          (match typ_dec t1 rhos Int with
             | Left ->
                 (match typ_dec t2 rhos t0 with
                    | Left ->
                        (match typ_dec t3 rhos (Arrow (Int, (Arrow (t0,
                                 t0)))) with
                           | Left -> type_dec t0 rho
                           | Right -> Right)
                    | Right -> Right)
             | Right -> Right)
  
  (** val whnf_total : term -> type0 -> coq_Answer **)
  
  let whnf_total r rho =
    match typ_dec r Nil rho with
      | Left -> Yes (whnf r rho)
      | Right -> No
 end

module Req = 
 struct 
  
 end

module Proof = NormalizationProof(Req)

