/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.TreeMap;

class Instrukcja
implements Serializable {
    public static final long serialVersionUID = 1311768467299033035L;
    public static final String wartosc = "=";
    public static final String wskaznik = "^";
    public final Rozkaz rozkaz;
    public final Argument argum;
    private String param;
    private Integer adres;
    private BigInteger liczba;

    public Instrukcja(Rozkaz rozkaz) throws NullPointerException, IllegalArgumentException {
        if (rozkaz == null) {
            throw new NullPointerException();
        }
        if (rozkaz != Rozkaz.nop && rozkaz != Rozkaz.halt && rozkaz != Rozkaz.inc && rozkaz != Rozkaz.dec && rozkaz != Rozkaz.neg) {
            throw new IllegalArgumentException();
        }
        this.rozkaz = rozkaz;
        this.argum = Argument.brak;
    }

    public Instrukcja(Rozkaz rozkaz, Argument argument, String string) throws NullPointerException, IllegalArgumentException {
        if (rozkaz == null || argument == null || string == null) {
            throw new NullPointerException();
        }
        if (!string.matches("^\\p{Alpha}\\p{Alnum}*$")) {
            throw new IllegalArgumentException();
        }
        if (argument == Argument.brak) {
            throw new IllegalArgumentException();
        }
        if (rozkaz == Rozkaz.nop || rozkaz == Rozkaz.halt || rozkaz == Rozkaz.inc || rozkaz == Rozkaz.dec || rozkaz == Rozkaz.neg) {
            throw new IllegalArgumentException();
        }
        this.rozkaz = rozkaz;
        this.argum = argument;
        this.param = string;
    }

    public Instrukcja(Rozkaz rozkaz, Argument argument, Integer n) throws NullPointerException, IllegalArgumentException {
        if (rozkaz == null || argument == null || n == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        switch (argument) {
            case etykieta: {
                if (rozkaz == Rozkaz.jump || rozkaz == Rozkaz.jzero || rozkaz == Rozkaz.jgtz || rozkaz == Rozkaz.jltz || rozkaz == Rozkaz.jnez || rozkaz == Rozkaz.jgez || rozkaz == Rozkaz.jlez) break;
                throw new IllegalArgumentException();
            }
            case komorka: 
            case wskaznik: {
                if (rozkaz == Rozkaz.write || rozkaz == Rozkaz.read || rozkaz == Rozkaz.load || rozkaz == Rozkaz.store || rozkaz == Rozkaz.add || rozkaz == Rozkaz.sub || rozkaz == Rozkaz.mul || rozkaz == Rozkaz.div || rozkaz == Rozkaz.mod) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.rozkaz = rozkaz;
        this.argum = argument;
        this.adres = n;
    }

    public Instrukcja(Rozkaz rozkaz, Argument argument, BigInteger bigInteger) throws NullPointerException, IllegalArgumentException {
        if (rozkaz == null || argument == null || bigInteger == null) {
            throw new NullPointerException();
        }
        if (argument != Argument.wartosc) {
            throw new IllegalArgumentException();
        }
        if (rozkaz != Rozkaz.write && rozkaz != Rozkaz.load && rozkaz != Rozkaz.add && rozkaz != Rozkaz.sub && rozkaz != Rozkaz.mul && rozkaz != Rozkaz.div && rozkaz != Rozkaz.mod) {
            throw new IllegalArgumentException();
        }
        this.rozkaz = rozkaz;
        this.argum = argument;
        this.liczba = bigInteger;
    }

    public String toString() {
        switch (this.argum) {
            case wartosc: {
                if (this.param != null) {
                    return String.format("%7s %s%s", new Object[]{this.rozkaz, wartosc, this.param});
                }
                return String.format("%7s %s%d", new Object[]{this.rozkaz, wartosc, this.liczba});
            }
            case komorka: {
                if (this.param != null) {
                    return String.format("%7s %s", new Object[]{this.rozkaz, this.param});
                }
                return String.format("%7s %d", new Object[]{this.rozkaz, this.adres});
            }
            case wskaznik: {
                if (this.param != null) {
                    return String.format("%7s %s%s", new Object[]{this.rozkaz, wskaznik, this.param});
                }
                return String.format("%7s %s%d", new Object[]{this.rozkaz, wskaznik, this.adres});
            }
            case etykieta: {
                if (this.param != null) {
                    return String.format("%7s %s", new Object[]{this.rozkaz, this.param});
                }
                return String.format("%7s X%06x", new Object[]{this.rozkaz, this.adres});
            }
        }
        return String.format("%7s ", new Object[]{this.rozkaz});
    }

    public String toString(Integer n) {
        switch (this.argum) {
            case wartosc: {
                if (n != null) {
                    return String.format("X%06x:%7s %s%d", new Object[]{n, this.rozkaz, wartosc, this.liczba});
                }
                return String.format("%15s %s%d", new Object[]{this.rozkaz, wartosc, this.liczba});
            }
            case komorka: {
                if (n != null) {
                    return String.format("X%06x:%7s %d", new Object[]{n, this.rozkaz, this.adres});
                }
                return String.format("%15s %d", new Object[]{this.rozkaz, this.adres});
            }
            case wskaznik: {
                if (n != null) {
                    return String.format("X%06x:%7s %s%d", new Object[]{n, this.rozkaz, wskaznik, this.adres});
                }
                return String.format("%15s %s%d", new Object[]{this.rozkaz, wskaznik, this.adres});
            }
            case etykieta: {
                if (n != null) {
                    return String.format("X%06x:%7s X%06x", new Object[]{n, this.rozkaz, this.adres});
                }
                return String.format("%15s X%06x", new Object[]{this.rozkaz, this.adres});
            }
        }
        if (n != null) {
            return String.format("X%06x:%7s", new Object[]{n, this.rozkaz});
        }
        return String.format("%15s", new Object[]{this.rozkaz});
    }

    public Rozkaz podajRozkaz() {
        return this.rozkaz;
    }

    public Argument podajArgument() {
        return this.argum;
    }

    public String sprawdzParametr() {
        return this.param;
    }

    String podajParam() {
        return this.param;
    }

    public Integer podajAdres() {
        return this.adres;
    }

    public BigInteger podajLiczbe() {
        return this.liczba;
    }

    void zmienEtykiete(int n, PrintWriter printWriter, TreeMap<String, Integer> treeMap) throws NumberFormatException {
        if (this.argum != Argument.etykieta) {
            return;
        }
        if (this.param == null) {
            return;
        }
        this.adres = treeMap.get(this.param);
        if (this.adres == null) {
            throw new NumberFormatException("odwo\u0142anie do niezadeklarowanej etykiety " + this.param);
        }
        this.param = null;
    }

    void zmienAdres(int n, PrintWriter printWriter, TreeMap<String, Integer> treeMap) throws NumberFormatException {
        if (this.argum != Argument.komorka && this.argum != Argument.wskaznik) {
            return;
        }
        if (this.param == null) {
            return;
        }
        this.adres = treeMap.get(this.param);
        if (this.adres == null) {
            throw new NumberFormatException("nie znaleziono adresu kom\u00f3rki " + this.param);
        }
        this.param = null;
    }

    void zmienWartosc(int n, PrintWriter printWriter, TreeMap<String, BigInteger> treeMap, TreeMap<String, Integer> treeMap2) throws NumberFormatException {
        if (this.argum != Argument.wartosc) {
            return;
        }
        if (this.param == null) {
            return;
        }
        this.liczba = treeMap.get(this.param);
        if (this.liczba == null) {
            Integer n2 = treeMap2.get(this.param);
            if (n2 == null) {
                throw new NumberFormatException("nie znaleziono warto\u015bci (adresu kom\u00f3rki) " + this.param);
            }
            this.liczba = new BigInteger(n2.toString());
        }
        this.param = null;
    }

    static enum Argument {
        brak,
        etykieta,
        wartosc,
        komorka,
        wskaznik;

    }

    static enum Rozkaz {
        nop,
        halt,
        jump,
        jzero,
        jgtz,
        jltz,
        jnez,
        jgez,
        jlez,
        write,
        read,
        load,
        store,
        add,
        sub,
        mul,
        div,
        inc,
        dec,
        neg,
        mod;

    }
}

