{-
:l 00_nbe.hs
tests
-} 

{-
This is a compositional evaluator rewritten from file "00 nbe.ml"
but let expressions are inlined.
-}

data Term = Var Int | App Term Term | Lam Term deriving (Eq, Show)

data Value = Abs (Value -> Value) | Neutral (Int -> Term)

lvar :: Int -> Value
lvar n = Neutral(\m -> Var (m-n))

normalize :: Int -> Value -> Term
normalize m (Neutral t) = t m
normalize m (Abs f) = Lam (normalize (m+1) $ f (lvar (m+1)))

apply_value :: Value -> Value -> Value
apply_value (Abs f) v = f v
apply_value (Neutral t) v = Neutral(\m -> App (t m) (normalize m v))

run :: Term -> [Value] -> Value
run (App t1 t2) e = apply_value (run t1 e) (run t2 e)
run (Lam t)     e = Abs(\v -> run t (v:e))
run (Var n)     e = e !! n

eval :: Term -> Term
eval t = normalize 0 $ run t []

iter :: Integer -> (a -> a) -> a -> a
iter 0 f x = x
iter n f x = iter (n-1) f (f x)

iden = Lam (Var 0)

yes = Lam (Lam (Var 1))
no  = Lam (Lam (Var 0))

omega = Lam (App (Var 0) (Var 0))
big_omega = App omega omega

church n = Lam( Lam( iter n (App (Var 1)) (Var 0) ))

explode n = Lam(App (App (church n) omega) (Var 0))

tests :: [Bool]
tests = [
  eval (App no big_omega) == iden,
  eval (explode 100) /= iden
  ]

