(*
#directory "../common";;
#load "../common/term.cmo";;
#use "00_nbe.ml";;
*)

(* This is the compositional evaluator from the APLAS'20 paper. It is
   an NbE (normalization by evaluation), full-reducing evaluator for
   lambda terms in de Bruijn notation, realizing the strong
   call-by-value strategy rrCbV.  *)

open Term;;

type level = int
type sem = Abs of (sem -> sem) | Neutral of (level -> term)

let rec reify (d : sem) (m : level) : term =
  match d with
  | Abs f ->
    Lam (reify (f (Neutral (fun m' -> Var (m'-m-1))))(m+1))
  | Neutral l ->
    l m

let to_sem (f : sem -> sem) : sem = Abs f

let from_sem (d : sem) : sem -> sem =
  fun d' ->
    match d with
    | Abs f ->
      f d'
    | Neutral l ->
      Neutral (fun m -> let n = reify d' m in App (l m, n))

let rec eval (t : term) (e : sem list) : sem =
  match t with
  | Var n -> List.nth e n
  | Lam t' -> to_sem (fun d -> eval t' (d :: e))
  | App (t1, t2) -> let d2 = eval t2 e
                    in from_sem (eval t1 e) d2

let nbe (t : term) : term = reify (eval t []) 0

(* tests *)
let _ = cbv_tests nbe
