(*
#directory "../common";;
#load "../common/namedTerm.cmo";;
#use "07b_stack.ml";;
*)


(* Here we defunctionalize the continuation of the "eval" function. *)

open NamedTerm

type 'a cache = 'a option ref

module Dict = Map.Make(struct type t = identifier let compare = compare end)

type value = Abs of identifier * n_term * env | Inert of inert
  | Cache of n_term cache * value
and inert = V of identifier | IApp of inert * value
  | ICache of n_term cache * inert
and env = value Dict.t

let gensym : unit -> int =
  let c = ref 0 in
  fun () ->
    let res = !c in
    c := res + 1;
    res

let rec env_lookup (x : identifier) (e : env) : value =
  match Dict.find_opt x e with
  | Some v -> v
  | None   -> Inert (V (x ^ "_free"))

let mount_cache (v:value) : value =
  match v with
  | Cache(_,_) -> v
  | _          -> Cache(ref None, v)

type frame2 = LAM of identifier | LAPP of inert | RAPP of n_term | CACHE of n_term cache
type stack2 = frame2 list

type stack1 = Lapp of n_term * env * stack1 | Rapp of value * stack1 | Reify of stack2

let rec eval (t : n_term) (e : env) (s1 : stack1) : n_term =
  match t with
  | NVar x        -> continue1 s1 @@ env_lookup x e
  | NLam (x, t')  -> continue1 s1 @@ Abs (x, t', e)
  | NApp (t1, t2) -> eval t2 e @@ Lapp (t1, e, s1)
and apply_abs (x : identifier) (t : n_term) (e : env) (v : value) (s1 : stack1) =
  eval t (Dict.add x (mount_cache v) e) s1
and apply_value (v : value) (v2 : value) (s1 : stack1) : n_term =
  match v with
  | Abs (x, t', e)     -> apply_abs x t' e v2 s1
  |           Inert i  -> continue1 s1 @@ apply_inert i v2
  | Cache (c, Inert i) -> continue1 s1 @@ apply_inert (ICache (c, i)) v2
  | Cache (c,       v) -> apply_value v v2 s1
and reify (v : value) (s2 : stack2) : n_term =
  match v with
  | Abs (x, t', e) ->
    let xm = x ^ "_" ^ string_of_int (gensym ()) in
    apply_abs x t' e (Inert (V xm)) @@ Reify (LAM xm::s2)
  | Inert i -> render_inert i s2
  | Cache (c, v) -> cached_reify c v s2
and cached_reify (d : n_term cache) (v : value) (s2 : stack2) : n_term =
  match !d with
  | Some y -> continue2 s2 y
  | None   -> reify v @@ CACHE d::s2
and apply_inert (i : inert) (v' : value) : value =
  Inert (IApp (i, v'))
and render_inert (i : inert) (s2 : stack2) : n_term =
  match i with
  | V x           -> continue2 s2 @@ NVar x
  | IApp (i, v)   -> reify v (LAPP i::s2)
  | ICache (c, i) -> cached_reify c (Inert i) s2
and continue1 (s1 : stack1) (v : value) : n_term =
  match s1 with
  | Lapp (t1, e, s1) -> eval t1 e @@ Rapp (v, s1)
  | Rapp (v2, s1)    -> apply_value v v2 s1
  | Reify s2         -> reify v s2
and continue2 (s2 : stack2) (t : n_term) : n_term =
  match s2 with
  | [] -> t
  | LAM xm::s2  -> continue2 s2 @@ NLam (xm, t)
  | LAPP i::s2  -> render_inert i @@ RAPP t::s2
  | RAPP n2::s2 -> continue2 s2 @@ NApp (t, n2)
  | CACHE d::s2 -> d := Some t;
                   continue2 s2 t

let normal_form (t : n_term) : n_term = eval t Dict.empty @@ Reify []

let _ = cbv_tests normal_form

