(*
#directory "../common";;
#load "../common/namedTerm.cmo";;
#use "01b_env.ml";;
*)

(* Environments are no longer hardcoded as lists. We replace them with dictionaries. *) 

open NamedTerm

type sem = Abs of (sem -> sem) | Neutral of (unit -> n_term)

let abstract_variable (x : identifier) : sem =
  let vx = NVar x in
  Neutral (fun () -> vx)

let gensym : unit -> int =
  let c = ref 0 in
  fun () ->
    let res = !c in
    c := res + 1;
    res

let rec reify : sem -> n_term =
  function
  | Abs f ->
    let xm = "x_" ^ string_of_int (gensym ()) in
    NLam (xm, reify (f @@ abstract_variable xm))
  | Neutral l ->
    l ()

let to_sem  (f : sem -> sem) : sem =  Abs f
    
let from_sem : sem -> (sem -> sem) =
  function
  | Abs f     -> f
  | Neutral l -> fun v' ->
    Neutral (fun () -> let n = reify v' in NApp (l (), n))

module Dict = Map.Make(struct type t = identifier let compare = compare end)

type env = sem Dict.t

let rec env_lookup (x : identifier) (e : env) : sem =
  match Dict.find_opt x e with
  | Some v -> v
  | None   -> abstract_variable (x ^ "_free")

let rec eval (t : n_term) (e : env) : sem =
  match t with
  | NVar x        -> env_lookup x e
  | NLam (x, t')  -> to_sem ( fun v -> eval t' @@ Dict.add x v e)
  | NApp (t1, t2) -> let v2 = eval t2 e
                     in from_sem (eval t1 e) v2

let nbe (t : n_term) : n_term = reify (eval t Dict.empty)

let _ = cbv_tests nbe

