(*
#directory "../common";;
#load "../common/namedTerm.cmo";;
#use "02a_renaming.ml";;
*)

(* type "sem" is renamed to "value" 
   function "from_sem" is renamed to "apply_value" 
   function "to_sem" is inlined 
   function "nbe" is renamed to "normal_form" *)
open NamedTerm

type 'a cache = 'a option ref

let cached_call (d : 'a cache) (t:unit -> 'a) : 'a =
  match !d with
  | Some y -> y
  | None   -> let y = t () in d := Some y; y

type value = Abs of (value -> value) | Neutral of (unit -> n_term)
  | Cache of n_term cache * value

let abstract_variable (x : identifier) : value =
  let vx = NVar x in
  Neutral (fun () -> vx)

let gensym : unit -> int =
  let c = ref 0 in
  fun () ->
    let res = !c in
    c := res + 1;
    res

let rec reify : value -> n_term =
  function
  | Abs f ->
    let xm = "x_" ^ string_of_int (gensym ()) in
    NLam (xm, reify (f @@ abstract_variable xm))
  | Neutral l ->
    l ()
  | Cache (c, v) -> cached_call c (fun () -> reify v)

                  
let rec apply_value : value -> (value -> value) =
  function
  | Abs f                -> f
  |           Neutral l  -> apply_neutral l
  | Cache (c, Neutral l) -> apply_neutral (fun () -> cached_call c l)
  | Cache (c,         v) -> apply_value v
and apply_neutral (l : unit -> n_term) (v' : value) : value =
  Neutral (fun () -> let n = reify v' in NApp (l (), n))

module Dict = Map.Make(struct type t = identifier let compare = compare end)

type env = value Dict.t

let rec env_lookup (x : identifier) (e : env) : value =
  match Dict.find_opt x e with
  | Some v -> v
  | None   -> abstract_variable (x ^ "_free")


let mount_cache (v:value) : value =
  match v with
  | Cache(_,_) -> v
  | _          -> Cache(ref None, v)

let rec eval (t : n_term) (e : env) : value =
  match t with
  | NVar x        -> env_lookup x e
  | NLam (x, t')  -> Abs (fun v -> eval t' @@ Dict.add x (mount_cache v) e)
  | NApp (t1, t2) -> let v2 = eval t2 e
                     in apply_value (eval t1 e) v2

let normal_form (t : n_term) : n_term = reify (eval t Dict.empty)

let _ = cbv_tests normal_form

