(*
#directory "../common";;
#load "../common/namedTerm.cmo";;
#use "08d.ml";;
*)

(* Some processing of inerts is identified in a new function "render_inert" *) 

open NamedTerm

type 'a cache = 'a option ref

module Dict = Map.Make(struct type t = identifier let compare = compare end)

type value = Abs of identifier * n_term * env | Inert of inert
  | Cache of n_term cache * value
and inert = V of identifier | IApp of inert * value
  | ICache of n_term cache * inert
and env = value Dict.t

let rec env_lookup (x : identifier) (e : env) : value =
  match Dict.find_opt x e with
  | Some v -> v
  | None   -> Inert (V (x ^ "_free"))

let mount_cache (v:value) : value =
  match v with
  | Cache(_,_) -> v
  | _          -> Cache(ref None, v)

type frame = Lapp of n_term * env | Rapp of value
  | LAM of identifier | LAPP of inert | RAPP of n_term | CACHE of n_term cache
type stack = frame list

let rec eval (m : int) (t : n_term) (e : env) (s1 : stack) : n_term =
  match t with
  | NVar x        -> continue1 m s1 @@ env_lookup x e
  | NLam (x, t')  -> continue1 m s1 @@ Abs (x, t', e)
  | NApp (t1, t2) -> eval m t2 e @@ Lapp (t1, e)::s1
and apply_abs (m : int) (x : identifier) (t : n_term) (e : env) (v : value) (s1 : stack) =
  eval m t (Dict.add x (mount_cache v) e) s1
and apply_value (m : int) (v : value) (v2 : value) (s1 : stack) : n_term =
  match v with
  | Abs (x, t', e)     -> apply_abs m x t' e v2 s1
  |           Inert i  -> continue1 m s1 @@ apply_inert i v2
  | Cache (c, Inert i) -> continue1 m s1 @@ apply_inert (ICache (c, i)) v2
  | Cache (c,       v) -> apply_value m v v2 s1
and cached_reify (d : n_term cache) (m : int) (v : value) (s2 : stack) : n_term =
  match !d with
  | Some y -> continue2 m s2 y
  | None   -> continue1 m (CACHE d::s2) v
and apply_inert (i : inert) (v' : value) : value =
  Inert (IApp (i, v'))
and continue1 (m : int) (s1 : stack) (v : value) : n_term =
  match s1 with
  | Lapp (t1, e)::s1 -> eval m t1 e @@ Rapp v::s1
  | Rapp v2::s1      -> apply_value m v v2 s1
  | s2               -> match v with
    | Abs (x, t', e) ->
      let xm = x ^ "_" ^ string_of_int m in
      apply_abs (m+1) x t' e (Inert (V xm)) @@ LAM xm::s2
    | Inert (V x)           -> continue2 m s2 @@ NVar x
    | Inert (IApp (i, v))   -> continue1 m (LAPP i::s2) v
    | Inert (ICache (c, i)) -> cached_reify c m (Inert i) s2
    | Cache (c, v) -> cached_reify c m v s2
and continue2 (m : int) (s2 : stack) (t : n_term) : n_term =
  match s2 with
  | [] -> t
  | LAM  xm::s2 -> continue2 m s2 @@ NLam (xm, t)
  | LAPP  i::s2 -> continue1 m (RAPP t::s2) (Inert i) 
  | RAPP n2::s2 -> continue2 m s2 @@ NApp (t, n2)
  | CACHE d::s2 -> d := Some t;
                   continue2 m s2 t
  | Lapp (_, _)::_ -> assert false
  | Rapp _::_      -> assert false

let normal_form (t : n_term) : n_term = eval 0 t Dict.empty []

let _ = cbv_tests normal_form

