(*
#directory "../common";;
#load "../common/namedTerm.cmo";;
#use "08f_entanglement.ml";;
*)


(* The functions "apply_inert" and "apply_abs" are inlined.  
   Nested pattern matching in "continue1" is entangled. *)
   
open NamedTerm

type 'a cache = 'a option ref

module Dict = Map.Make(struct type t = identifier let compare = compare end)

type value = Abs of identifier * n_term * env | Inert of inert
  | Cache of n_term cache * value
and inert = V of identifier | IApp of inert * value
  | ICache of n_term cache * inert
and env = value Dict.t

let rec env_lookup (x : identifier) (e : env) : value =
  match Dict.find_opt x e with
  | Some v -> v
  | None   -> Inert (V (x ^ "_free"))

type frame = Lapp of n_term * env | Rapp of value
  | LAM of identifier | LAPP of inert | RAPP of n_term | CACHE of n_term cache
type stack = frame list

let rec eval (m : int) (t : n_term) (e : env) (s1 : stack) : n_term =
  match t with
  | NVar x        -> continue1 m s1 @@ env_lookup x e
  | NLam (x, t')  -> continue1 m s1 @@ Abs (x, t', e)
  | NApp (t1, t2) -> eval m t2 e @@ Lapp (t1, e)::s1
and continue1 (m : int) (s1 : stack) (v : value) : n_term =
  match s1, v with
  | Lapp (t1, e)::s1, _ -> eval m t1 e @@ Rapp v::s1
  | Rapp (Cache(_, _) as v2)::s1', Abs (x, t', e) -> eval m t' (Dict.add x v2 e) s1'
  | Rapp v2::s1', Abs (_, _, _)                   -> continue1 m (Rapp (Cache (ref None, v2))::s1') v
  | Rapp v2::s1',           Inert i  -> continue1 m s1' @@ Inert (IApp (i, v2))
  | Rapp v2::s1', Cache (c, Inert i) -> continue1 m s1' @@ Inert (IApp (ICache (c, i), v2))
  | Rapp v2::s1', Cache (c,       v) -> continue1 m s1 v
  | s2, Abs (x, t', e) -> let xm = x ^ "_" ^ string_of_int m in
      eval (m+1) t' (Dict.add x (Cache (ref None, Inert (V xm))) e) @@ LAM xm::s2
  | s2, Inert (V x)           -> continue2 m s2 @@ NVar x
  | s2, Inert (IApp (i, v))   -> continue1 m (LAPP i::s2) v
  | s2, Inert (ICache (c, i)) -> cached_reify (!c) c m (Inert i) s2
  | s2, Cache (c, v) -> cached_reify (!c) c m v s2
and cached_reify (t : n_term option) (d : n_term cache) (m : int) (v : value) (s2 : stack) : n_term =
  match t with
  | Some y -> continue2 m s2 y
  | None   -> continue1 m (CACHE d::s2) v
and continue2 (m : int) (s2 : stack) (t : n_term) : n_term =
  match s2 with
  | [] -> t
  | LAM  xm::s2 -> continue2 m s2 @@ NLam (xm, t)
  | LAPP  i::s2 -> continue1 m (RAPP t::s2) (Inert i) 
  | RAPP n2::s2 -> continue2 m s2 @@ NApp (t, n2)
  | CACHE d::s2 -> d := Some t;
                   continue2 m s2 t
  | Lapp (_, _)::_ -> assert false
  | Rapp _::_      -> assert false

let normal_form (t : n_term) : n_term = eval 0 t Dict.empty []

let _ = cbv_tests normal_form

