using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Runtime.InteropServices;
using System.Text;

namespace MiddleTier
{
	public class C_Sql
	{
		#region ListAvailableServers
		[DllImport("odbc32.dll")]
		private static extern short SQLAllocHandle(short hType, IntPtr inputHandle, out IntPtr outputHandle);
		[DllImport("odbc32.dll")]
		private static extern short SQLSetEnvAttr(IntPtr henv, int attribute, IntPtr valuePtr, int strLength);
		[DllImport("odbc32.dll")]
		private static extern short SQLFreeHandle(short hType, IntPtr handle); 
		[DllImport("odbc32.dll",CharSet=CharSet.Ansi)]
		private static extern short SQLBrowseConnect(IntPtr hconn, StringBuilder inString, 
			short inStringLength, StringBuilder outString, short outStringLength,
			out short outLengthNeeded);

		private const short SQL_HANDLE_ENV = 1;
		private const short SQL_HANDLE_DBC = 2;
		private const int SQL_ATTR_ODBC_VERSION = 200;
		private const int SQL_OV_ODBC3 = 3;
		private const short SQL_SUCCESS = 0;
		
		private const short SQL_NEED_DATA = 99;
		private const short DEFAULT_RESULT_SIZE = 1024;
		private const string SQL_DRIVER_STR = "DRIVER=SQL SERVER";
	
		public static ArrayList ListAvailableSQLServers_ODBC()
		{
			string txt   = string.Empty;
			IntPtr henv  = IntPtr.Zero;
			IntPtr hconn = IntPtr.Zero;
			StringBuilder inString  = new StringBuilder(SQL_DRIVER_STR);
			StringBuilder outString = new StringBuilder(DEFAULT_RESULT_SIZE);
			short inStringLength = (short) inString.Length;
			short lenNeeded = 0;

			try
			{
				if ( SQL_SUCCESS == SQLAllocHandle(SQL_HANDLE_ENV, henv, out henv) )
				{
					if (SQL_SUCCESS == SQLSetEnvAttr(henv,SQL_ATTR_ODBC_VERSION,(IntPtr)SQL_OV_ODBC3,0))
					{
						if (SQL_SUCCESS == SQLAllocHandle(SQL_HANDLE_DBC, henv, out hconn))
						{
							if (SQL_NEED_DATA ==  SQLBrowseConnect(hconn, inString, inStringLength, outString, 
								DEFAULT_RESULT_SIZE, out lenNeeded))
							{
								if (DEFAULT_RESULT_SIZE < lenNeeded)
								{
									outString.Capacity = lenNeeded;
									if (SQL_NEED_DATA != SQLBrowseConnect(hconn, inString, inStringLength, outString, 
										lenNeeded,out lenNeeded))
									{
										throw new Exception( "B-d pobierania listy serwerw SQL od sterownika ODBC." );
									}	
								}
								txt = outString.ToString();
								int start = txt.IndexOf("{") + 1;
								int len = txt.IndexOf("}") - start;
								if ((start > 0) && (len > 0))
								{
									txt = txt.Substring(start,len);
								}
								else
								{
									txt = string.Empty;
								}
							}						
						}
					}
				}
			}
			catch
			{
				txt = string.Empty;
			}
			finally
			{
				if ( hconn != IntPtr.Zero )
				{
					SQLFreeHandle(SQL_HANDLE_DBC,hconn);
				}
				if ( henv != IntPtr.Zero )
				{
					SQLFreeHandle(SQL_HANDLE_ENV,hconn);
				}
			}
	
			ArrayList aRet = new ArrayList();
			if ( txt.Length > 0 )
			{
				string[] retval = txt.Split( new char[] { ',' } );
				foreach ( string s in retval )
					aRet.Add( s );
			}

			return aRet;
		}
		#endregion

		#region ListAvailableDatabases
		public static ArrayList ListAvailableDatabases( string sServer, string sUser, string sPasswd )
		{
			SqlConnection sqlConnection=null;

			try
			{
				sqlConnection = new SqlConnection();
				sqlConnection.ConnectionString = BuildConnectionString( sServer, sUser, C_MyConsts.DB_Master, sPasswd );
				sqlConnection.Open();

				SqlCommand sqlCommand  = new SqlCommand( C_MyConsts.DB_HelpDB, sqlConnection );
				sqlCommand.CommandType = CommandType.StoredProcedure;
				SqlDataReader sqlR = sqlCommand.ExecuteReader();

				ArrayList aRet = new ArrayList();
				while( sqlR.Read() )
					aRet.Add( (string)sqlR["name"] );

				return aRet;
			}
			catch
			{
				return new ArrayList();
			}
		}
		#endregion

		#region GetDatabaseInfo
		public static SQL_Table[] GetDatabaseInfo( SqlConnection sqlConn )
		{
			try
			{
				if ( sqlConn.State != ConnectionState.Open ) sqlConn.Open();

				#region Tables
				ArrayList       aT = new ArrayList();
				SqlCommand    sqlC = new SqlCommand( "sp_tables", sqlConn );
				sqlC.CommandType   = CommandType.StoredProcedure;
				SqlDataReader sqlR = sqlC.ExecuteReader();

				while( sqlR.Read() )
					if ( (string)sqlR["TABLE_TYPE"] == "TABLE" )
					{
						SQL_Table t = new SQL_Table();
						t.Name = (string)sqlR["TABLE_NAME"];
						aT.Add( t );
					}
				SQL_Table[] rT = new SQL_Table[aT.Count];
				aT.CopyTo( rT );
				sqlR.Close();
				
				foreach ( SQL_Table t in rT )
				{
					#region Primary key
					sqlC = new SqlCommand( string.Format( "sp_pkeys {0}", t.Name ), sqlConn );
					sqlR = sqlC.ExecuteReader();
					if ( sqlR.Read() )
					{
						t.PK_NAME = (string)sqlR["COLUMN_NAME"];
					}
					sqlR.Close();
					#endregion
					#region Fields
					sqlC = new SqlCommand( string.Format( "sp_columns {0}", t.Name ), sqlConn );
					sqlR = sqlC.ExecuteReader();
					ArrayList aF = new ArrayList();

					while( sqlR.Read() )
					{
						SQL_Field f = new SQL_Field();
						f.Name   = (string)sqlR["COLUMN_NAME"];
						f.Length = (int)sqlR["LENGTH"];
						f.Type   = (string)sqlR["TYPE_NAME"];
						f.AllowNulls = ( (short)sqlR["NULLABLE"]==1 ? true : false );
						aF.Add( f );
					}
					SQL_Field[] tF = new SQL_Field[aF.Count];
					aF.CopyTo( tF );
					sqlR.Close();
					t.Fields = tF;
					#endregion
					#region Constraints
					sqlC = new SqlCommand( string.Format( "sp_fkeys @fktable_name={0}", t.Name ), sqlConn );
					sqlR = sqlC.ExecuteReader();
					ArrayList aC = new ArrayList();

					while( sqlR.Read() )
					{
						SQL_Constraint c = new SQL_Constraint();
						c.Name           = (string)sqlR["FK_NAME"];
						c.FKTABLE_NAME   = (string)sqlR["FKTABLE_NAME"];
						c.FKCOLUMN_NAME  = (string)sqlR["FKCOLUMN_NAME"];
						c.PKTABLE_NAME   = (string)sqlR["PKTABLE_NAME"];
						c.PKCOLUMN_NAME  = (string)sqlR["PKCOLUMN_NAME"];
						aC.Add( c );
					}
					SQL_Constraint[] tC = new SQL_Constraint[aC.Count];
					aC.CopyTo( tC );
					sqlR.Close();
					t.Constraints = tC;
					#endregion
				}
				
				return rT;
				#endregion
			}
			catch
			{
				return null;
			}
			finally
			{
				if ( sqlConn.State == ConnectionState.Open )
					sqlConn.Close();
			}
		}
		#endregion

		#region BuildConnectionString
		public static string BuildConnectionString(string serverName, string userName, string dbName, string passWd)
		{
			return String.Format(  
				@"Server={0};Database={1};User ID={2};Pwd={3};Connect Timeout=20", 
				serverName, dbName, userName, passWd);
		}
		#endregion

		private C_Sql() {}
	}
}
