using System;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace MiddleTier
{
	public class f_Connection : System.Windows.Forms.Form
	{
		#region Construction
		private System.Windows.Forms.GroupBox gbConnection;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox cbServer;
		private System.Windows.Forms.GroupBox gbUser;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.TextBox txtUser;
		private System.Windows.Forms.TextBox txtPassword;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ComboBox cbDatabase;
		private System.Windows.Forms.Label lblDatabase;
		private System.Windows.Forms.Button btOK;
		private System.Windows.Forms.Button Cancel;
		private System.ComponentModel.Container components = null;

		public f_Connection()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.gbConnection = new System.Windows.Forms.GroupBox();
			this.cbDatabase = new System.Windows.Forms.ComboBox();
			this.lblDatabase = new System.Windows.Forms.Label();
			this.gbUser = new System.Windows.Forms.GroupBox();
			this.txtPassword = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.txtUser = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.cbServer = new System.Windows.Forms.ComboBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btOK = new System.Windows.Forms.Button();
			this.Cancel = new System.Windows.Forms.Button();
			this.gbConnection.SuspendLayout();
			this.gbUser.SuspendLayout();
			this.SuspendLayout();
			// 
			// gbConnection
			// 
			this.gbConnection.Controls.Add(this.cbDatabase);
			this.gbConnection.Controls.Add(this.lblDatabase);
			this.gbConnection.Controls.Add(this.gbUser);
			this.gbConnection.Controls.Add(this.cbServer);
			this.gbConnection.Controls.Add(this.label1);
			this.gbConnection.Location = new System.Drawing.Point(4, 8);
			this.gbConnection.Name = "gbConnection";
			this.gbConnection.Size = new System.Drawing.Size(352, 164);
			this.gbConnection.TabIndex = 0;
			this.gbConnection.TabStop = false;
			this.gbConnection.Text = "Connection";
			// 
			// cbDatabase
			// 
			this.cbDatabase.Location = new System.Drawing.Point(100, 132);
			this.cbDatabase.Name = "cbDatabase";
			this.cbDatabase.Size = new System.Drawing.Size(244, 21);
			this.cbDatabase.TabIndex = 4;
			this.cbDatabase.DropDown += new System.EventHandler(this.cbDatabase_DropDown);
			// 
			// lblDatabase
			// 
			this.lblDatabase.Location = new System.Drawing.Point(8, 136);
			this.lblDatabase.Name = "lblDatabase";
			this.lblDatabase.Size = new System.Drawing.Size(80, 16);
			this.lblDatabase.TabIndex = 3;
			this.lblDatabase.Text = "Database:";
			// 
			// gbUser
			// 
			this.gbUser.Controls.Add(this.txtPassword);
			this.gbUser.Controls.Add(this.label2);
			this.gbUser.Controls.Add(this.txtUser);
			this.gbUser.Controls.Add(this.lblName);
			this.gbUser.Location = new System.Drawing.Point(8, 52);
			this.gbUser.Name = "gbUser";
			this.gbUser.Size = new System.Drawing.Size(336, 72);
			this.gbUser.TabIndex = 2;
			this.gbUser.TabStop = false;
			this.gbUser.Text = "User";
			// 
			// txtPassword
			// 
			this.txtPassword.Location = new System.Drawing.Point(92, 44);
			this.txtPassword.Name = "txtPassword";
			this.txtPassword.PasswordChar = '*';
			this.txtPassword.Size = new System.Drawing.Size(236, 20);
			this.txtPassword.TabIndex = 3;
			this.txtPassword.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 16);
			this.label2.TabIndex = 2;
			this.label2.Text = "Password:";
			// 
			// txtUser
			// 
			this.txtUser.Location = new System.Drawing.Point(92, 20);
			this.txtUser.Name = "txtUser";
			this.txtUser.Size = new System.Drawing.Size(236, 20);
			this.txtUser.TabIndex = 1;
			this.txtUser.Text = "";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 24);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(72, 16);
			this.lblName.TabIndex = 0;
			this.lblName.Text = "Name:";
			// 
			// cbServer
			// 
			this.cbServer.Location = new System.Drawing.Point(100, 24);
			this.cbServer.Name = "cbServer";
			this.cbServer.Size = new System.Drawing.Size(244, 21);
			this.cbServer.TabIndex = 1;
			this.cbServer.DropDown += new System.EventHandler(this.cbServer_DropDown);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 28);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Server:";
			// 
			// btOK
			// 
			this.btOK.Location = new System.Drawing.Point(4, 176);
			this.btOK.Name = "btOK";
			this.btOK.Size = new System.Drawing.Size(88, 24);
			this.btOK.TabIndex = 1;
			this.btOK.Text = "OK";
			this.btOK.Click += new System.EventHandler(this.btOK_Click);
			// 
			// Cancel
			// 
			this.Cancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Cancel.Location = new System.Drawing.Point(268, 176);
			this.Cancel.Name = "Cancel";
			this.Cancel.Size = new System.Drawing.Size(88, 24);
			this.Cancel.TabIndex = 2;
			this.Cancel.Text = "Cancel";
			this.Cancel.Click += new System.EventHandler(this.Cancel_Click);
			// 
			// f_Connection
			// 
			this.AcceptButton = this.btOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.Cancel;
			this.ClientSize = new System.Drawing.Size(360, 204);
			this.Controls.Add(this.Cancel);
			this.Controls.Add(this.btOK);
			this.Controls.Add(this.gbConnection);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "f_Connection";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "MS SQL Connection Creator";
			this.gbConnection.ResumeLayout(false);
			this.gbUser.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion
		#region Properties
		SqlConnection m_sqlCon = null;
		public SqlConnection SqlConnection
		{
			get
			{
				return m_sqlCon;
			}
		}
		#endregion
		#region Component code
		private void cbServer_DropDown(object sender, System.EventArgs e)
		{
			ArrayList aS = C_Sql.ListAvailableSQLServers_ODBC();

			cbServer.Items.Clear();
			foreach ( string s in aS )
				cbServer.Items.Add( s );
		}

		private void cbDatabase_DropDown(object sender, System.EventArgs e)
		{
			ArrayList aD = C_Sql.ListAvailableDatabases( cbServer.Text, txtUser.Text, txtPassword.Text );

			cbDatabase.Items.Clear();
			foreach ( string d in aD )
				cbDatabase.Items.Add( d );
		}

		private void btOK_Click(object sender, System.EventArgs e)
		{
			m_sqlCon = new SqlConnection();
			m_sqlCon.ConnectionString = C_Sql.BuildConnectionString( cbServer.Text, txtUser.Text, cbDatabase.Text, txtPassword.Text );
			
			this.DialogResult = DialogResult.OK;
			Close();		
		}

		private void Cancel_Click(object sender, System.EventArgs e)
		{
			m_sqlCon = null;
			Close();
		}
		#endregion
	}
}
