using System;
using System.Text;
using System.Windows.Forms;

namespace MiddleTier
{
	public class C_OVaria
	{
		#region ProperCase
		public static string ToProperCase( string s )
		{
			if ( s.Length == 0 ) return s;

			// usu nadmiar spacji
			s = s.Trim();

			bool bUpper = true;
			string res = string.Empty;
			foreach ( char c in s )
			{
				res += ( bUpper ? c.ToString().ToUpper() : c.ToString().ToLower() );
				bUpper = false;
				
				if ( c == ' ' || c == '-' ) bUpper = true;
			}

			return res;
		}

		public static string ToProperCase_Parts( string sString )
		{
			string[] sP = sString.Split( new char[] { '_' } );

			StringBuilder sb = new StringBuilder();
			foreach ( string s in sP )
			{
				sb.Append( ToProperCase( s ) );
				sb.Append( "_" );
			}
			if ( sb.Length > 0 ) sb.Remove( sb.Length-1, 1 );

			return sb.ToString();
		}
		#endregion

		public static void ListViewAutoSize( ListView lItems )
		{
			foreach ( ColumnHeader ch in lItems.Columns ) ch.Width = -2;
		}

		private C_OVaria() {}
	}
}
