using System;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace MiddleTier
{
	public class f_DB : System.Windows.Forms.Form
	{
		#region Construction
		const string S_FIELDS = "Fields";
		const string S_CONSTS = "Constraints";

		private SQL_Table[] sqlTables;
		private SqlConnection sqlConnection = null;
		private System.Windows.Forms.TreeView tvTables;
		private System.Windows.Forms.ListView lstItems;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.MainMenu mnuMain;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem mnuClasses;
		private System.ComponentModel.Container components = null;

		public f_DB()
		{
			InitializeComponent();

			f_Connection fC = new f_Connection();
			DialogResult res = fC.ShowDialog();
			if ( res == DialogResult.OK )
			{
				this.sqlConnection = fC.SqlConnection;
				this.Text = string.Format( "{0}: {1}", sqlConnection.DataSource, sqlConnection.Database );

				sqlTables = C_Sql.GetDatabaseInfo( sqlConnection );
				InitializeTables();
			}
			else
				this.Text = "Not connected";
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.tvTables = new System.Windows.Forms.TreeView();
			this.lstItems = new System.Windows.Forms.ListView();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.mnuMain = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.mnuClasses = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// tvTables
			// 
			this.tvTables.Dock = System.Windows.Forms.DockStyle.Left;
			this.tvTables.HideSelection = false;
			this.tvTables.ImageIndex = -1;
			this.tvTables.Location = new System.Drawing.Point(0, 0);
			this.tvTables.Name = "tvTables";
			this.tvTables.SelectedImageIndex = -1;
			this.tvTables.Size = new System.Drawing.Size(192, 342);
			this.tvTables.TabIndex = 0;
			this.tvTables.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvTables_AfterSelect);
			// 
			// lstItems
			// 
			this.lstItems.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lstItems.FullRowSelect = true;
			this.lstItems.GridLines = true;
			this.lstItems.Location = new System.Drawing.Point(196, 0);
			this.lstItems.Name = "lstItems";
			this.lstItems.Size = new System.Drawing.Size(312, 342);
			this.lstItems.TabIndex = 1;
			this.lstItems.View = System.Windows.Forms.View.Details;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(192, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(4, 342);
			this.splitter1.TabIndex = 2;
			this.splitter1.TabStop = false;
			// 
			// mnuMain
			// 
			this.mnuMain.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.menuItem1});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.mnuClasses});
			this.menuItem1.Text = "Middle-Tier";
			// 
			// mnuClasses
			// 
			this.mnuClasses.Index = 0;
			this.mnuClasses.Text = "Generate Class Files";
			this.mnuClasses.Click += new System.EventHandler(this.mnuClasses_Click);
			// 
			// f_DB
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(508, 342);
			this.Controls.Add(this.lstItems);
			this.Controls.Add(this.splitter1);
			this.Controls.Add(this.tvTables);
			this.Menu = this.mnuMain;
			this.Name = "f_DB";
			this.Text = "f_DB";
			this.ResumeLayout(false);

		}
		#endregion
		#endregion
		#region Logic
		void InitializeTables()
		{
			tvTables.Nodes.Clear();
			if ( sqlTables != null )
				foreach ( SQL_Table sT in sqlTables )
				{
					TreeNode tD = tvTables.Nodes.Add( sT.Name );
					tD.Tag      = sT;

					TreeNode tT  = new TreeNode( S_FIELDS );
					tT.ForeColor = Color.Blue;
					tD.Nodes.Add( tT );
							
					TreeNode tC  = new TreeNode( S_CONSTS );
					tC.ForeColor = Color.Blue;
					tD.Nodes.Add( tC );
				}
		}
		void InitializeFields( SQL_Table sTable )
		{
			string[] col = { "Name", "Type", "Length", "Allow nulls" };
			foreach ( string c in col ) lstItems.Columns.Add( c, 60, HorizontalAlignment.Left );

			foreach ( SQL_Field sF in sTable.Fields )
			{
				ListViewItem li = lstItems.Items.Add( sF.Name );
				li.SubItems.Add( sF.Type );
				li.SubItems.Add( sF.Length.ToString() );
				li.SubItems.Add( sF.AllowNulls.ToString() );
			}

			C_OVaria.ListViewAutoSize( lstItems );
		}
		void InitializeConsts( SQL_Table sTable )
		{
			string[] col = { "Field", "Dest table", "Dest field", "Name" };
			foreach ( string c in col ) lstItems.Columns.Add( c, 60, HorizontalAlignment.Left );

			foreach ( SQL_Constraint sC in sTable.Constraints )
			{
				ListViewItem li = lstItems.Items.Add( sC.FKCOLUMN_NAME );
				li.SubItems.Add( sC.PKTABLE_NAME );
				li.SubItems.Add( sC.PKCOLUMN_NAME );
				li.SubItems.Add( sC.Name );
			}

			C_OVaria.ListViewAutoSize( lstItems );
		}
		#endregion
		#region Component code
		private void mnuClasses_Click(object sender, System.EventArgs e)
		{
			try
			{
				MT_Params mt = new MT_Params();		
				if ( mt.ShowDialog() == DialogResult.OK )
				{
					MT_Generator.GenerateClassTemplates( mt.SelectedPath, sqlTables );
					MessageBox.Show( "Classes have been generated.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information );
				}
			}
			catch ( Exception ex )
			{
				MessageBox.Show( ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error );
			}
		}
		private void tvTables_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if ( e.Node != null )
			{
				lstItems.Items.Clear();
				lstItems.Columns.Clear();

				if ( e.Node.Text == S_FIELDS ) InitializeFields( e.Node.Parent.Tag as SQL_Table );
				if ( e.Node.Text == S_CONSTS ) InitializeConsts( e.Node.Parent.Tag as SQL_Table );
			}
		}
		#endregion
	}
}
