using System;
using System.Reflection;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace MiddleTier
{
	public class MT_Generator
	{
		public static void GenerateClassTemplates( string sFolder, SQL_Table[] sqlTable )
		{
			GenerateConstFiles( sFolder, sqlTable );
			GenerateVarFiles( sFolder, sqlTable );
			GenerateClassFiles( sFolder, sqlTable );
		}

		#region MT Generation
		const string F_CEXT   = ".cs";	
		const string F_TEXT   = ".mt_template";	
		const string F_       = "C_";
		const string F_BASE   = "C_Base";
		const string F_FIELD  = "C_Field";
		const string F_HASH   = "C_OHashTable";
		const string F_SQL    = "C_OSql";
		const string F_CPDATA = "C_PData";
		const string F_CPDATAINITS = "C_PDataInits";
		const string F_CPDATASTORE = "C_PDataStore";
		private static void GenerateConstFiles( string sFolder, SQL_Table[] sqlTable )
		{
			// base, field
			SaveFile( sFolder, F_BASE+F_CEXT,  ResHelper.GetFileContent( F_BASE+F_TEXT ) );
			SaveFile( sFolder, F_FIELD+F_CEXT, ResHelper.GetFileContent( F_FIELD+F_TEXT ) );
			SaveFile( sFolder, F_HASH+F_CEXT,  ResHelper.GetFileContent( F_HASH+F_TEXT ) );
			SaveFile( sFolder, F_SQL+F_CEXT,   ResHelper.GetFileContent( F_SQL+F_TEXT ) );
		}
		private static void GenerateVarFiles( string sFolder, SQL_Table[] sqlTable )
		{
			StringBuilder sb;
			#region C_PData
			string cpdata = ResHelper.GetFileContent( F_CPDATA + F_TEXT );

			sb = new StringBuilder();
			foreach ( SQL_Table t in sqlTable )
			{
				sb.Append( string.Format( "\t\tpublic static C_OHashTable {0} = new C_OHashTable( typeof({1}), \"{2}\", \"{3}\", \"{2}\");\r\n",
                    t.Name_Collection, t.Name_Type, t.Name, t.PK_NAME ) );
			}

			cpdata = cpdata.Replace( "_COLLECTIONS_", sb.ToString() );

			SaveFile( sFolder, F_CPDATA+F_CEXT, cpdata );
			#endregion
			#region C_PDataInits
			string cpdatainits = ResHelper.GetFileContent( F_CPDATAINITS + F_TEXT );

			sb = new StringBuilder();
			foreach ( SQL_Table t in sqlTable )
			{
				sb.Append( string.Format( "\t\t\t\tC_PDataInits.Init_Table ( C_PData.{0}, -1, true );\r\n",
					t.Name_Collection ) );
			}

			cpdatainits = cpdatainits.Replace( "_INIT_COLLECTIONS_", sb.ToString() );

			SaveFile( sFolder, F_CPDATAINITS+F_CEXT, cpdatainits );
			#endregion
			#region C_PDataStore
			string cpdatastore = ResHelper.GetFileContent( F_CPDATASTORE + F_TEXT );

			sb = new StringBuilder();
			SQL_Table[] sqlTableSorted = new SQL_Table[sqlTable.Length];
			Array.Copy( sqlTable, sqlTableSorted, sqlTable.Length );
			Array.Sort( sqlTableSorted, SQL_Table.Sort_Dependency );
			foreach ( SQL_Table t in sqlTableSorted )
			{
				sb.Append( string.Format( "\t\t\t\t\tInsUpd_Table_0 ( C_PData.{0} );\r\n",
					t.Name_Collection ) );
			}

			cpdatastore = cpdatastore.Replace( "_STORE_COLLECTIONS_", sb.ToString() );

			SaveFile( sFolder, F_CPDATASTORE+F_CEXT, cpdatastore );
			#endregion
		}
		private static void GenerateClassFiles( string sFolder, SQL_Table[] sqlTable )
		{
			string cc = ResHelper.GetFileContent( F_ + F_TEXT );
			
			foreach ( SQL_Table t in sqlTable )
			{
				string cp = cc;

				cp = cp.Replace( "_TYPENAME_", t.Name_Type );
				#region Field declaration
				StringBuilder sf = new StringBuilder();
				foreach ( SQL_Field f in t.Fields )
				{
					if ( f.Type != "int identity" )
						sf.AppendFormat( "\t\t[C_Field()]\r\n\t\tpublic {0} {1};\r\n",
							f.Name_Type, f.Name );
				}
				cp = cp.Replace( "_FIELDDECLARATION_", sf.ToString() );
				#endregion
				#region Logic
				StringBuilder sl = new StringBuilder();
				foreach ( SQL_Constraint c in t.Constraints )
				{
					SQL_Table tc = c.SQL_PKTable( sqlTable );

					sl.AppendFormat( "\t\tpublic {0} {1}\r\n", tc.Name_Type, c.Name_Property );
					sl.Append( "\t\t{\r\n" );
					sl.Append( "\t\t\tget\r\n" );
					sl.Append( "\t\t\t{\r\n" );
					sl.AppendFormat( "\t\t\t\treturn ({0})C_PData.{1}[{2}];\r\n", tc.Name_Type, tc.Name_Collection, c.FKCOLUMN_NAME );
					sl.Append( "\t\t\t}\r\n" );
					sl.Append( "\t\t}\r\n" );
					sl.Append( "\r\n" );
				}
				cp = cp.Replace( "_LOGIC_", sl.ToString() );
				#endregion
				#region SqlInsert
				StringBuilder sins = new StringBuilder();
				sins.Append ( "\"INSERT {0} \"+\r\n\t\t\t\"(" );
 
				foreach ( SQL_Field f in t.Fields )
				{
					if ( f.Type != "int identity" )
					{
						sins.Append( f.Name );
						sins.Append( ", " );
					}
				}
				sins.Remove( sins.Length-2, 2 );
				
				sins.Append( ")\"+\r\n\t\t\t\"VALUES\"+\r\n\t\t\t\"(" );
				
				int fno = 1;
				foreach ( SQL_Field f in t.Fields )
				{
					if ( f.Type != "int identity" )
					{
						if ( f.IsLiteralType ) sins.Append( "'" );
						sins.Append( "{" );
						sins.Append( (fno++).ToString() );
						sins.Append( "}" );
						if ( f.IsLiteralType ) sins.Append( "'" );
						sins.Append( ", " );
					}
				}
				sins.Remove( sins.Length-2, 2 );

				sins.Append( ")\"+\r\n\t\t\t\"SELECT CAST(SCOPE_IDENTITY() AS INT)\"" );

				cp = cp.Replace( "_INSERTSQL_", sins.ToString() );
				#endregion
				#region SqlUpdate
				StringBuilder supd = new StringBuilder();
				supd.Append ( "\"UPDATE {1} SET \"+\r\n\t\t\t\"(" );
 				
				fno = 2;
				foreach ( SQL_Field f in t.Fields )
				{
					if ( f.Type != "int identity" )
					{
						supd.Append( f.Name );
						supd.Append( "=" );
						if ( f.IsLiteralType ) supd.Append( "'" );
						supd.Append( "{" );
						supd.Append( (fno++).ToString() );
						supd.Append( "}" );
						if ( f.IsLiteralType ) supd.Append( "'" );
						supd.Append( ", " );
					}
				}
				supd.Remove( supd.Length-2, 2 );

				supd.Append( "\"+\r\n\t\t\t\"WHERE {" );
				supd.Append( (fno++).ToString() );
				supd.Append( "}={0} SELECT {0}" );

				cp = cp.Replace( "_UPDATESQL_", supd.ToString() );
				#endregion
				#region SqlFields
				StringBuilder sfs = new StringBuilder();

				foreach ( SQL_Field f in t.Fields )
					if ( f.Type != "int identity" )
					{
						SQL_Constraint c = f.SQL_PConstraint( t );
						if ( c == null )
							sfs.AppendFormat( "\t\t\t\t\t{0}, \r\n", f.Name );
						else
							sfs.AppendFormat( "\t\t\t\t\t{0}.ID_DB, \r\n", c.Name_Property );
					}				
				sfs.Remove( sfs.Length-3, 3 );
				cp = cp.Replace( "_SQLFIELDS_", sfs.ToString() );
				#endregion

				SaveFile( sFolder, t.Name_Type+F_CEXT, cp );
			}
		}
		#region Helpers
		private static void SaveFile( string sFolder, string sFilename, string sFileContent )
		{
			if ( !sFolder.EndsWith(@"\") )  sFolder = sFolder + @"\";
			using ( FileStream fs = new FileStream( sFolder+sFilename, FileMode.Create ) )
			using ( StreamWriter sw = new StreamWriter( fs ) )
				sw.Write( sFileContent );
		}
		#endregion
		#endregion

		private MT_Generator() {}
	}
}
