using System;

namespace MiddleTier
{
	public class SQL_Field
	{
		public string Name;
		public string Type;
		public int    Length;
		public bool   AllowNulls;

		public SQL_Constraint SQL_PConstraint( SQL_Table sqlTable )
		{
			foreach ( SQL_Constraint c in sqlTable.Constraints )
				if ( c.FKCOLUMN_NAME == this.Name )
					return c;

			return null;
		}

		public bool IsLiteralType
		{
			get
			{
				switch( Type )
				{
					case "char"     : 
					case "varchar"  : 
					case "nchar"    : 
					case "nvarchar" : 
					case "datetime" : 
						return true;
					default : return false;
				}				
			}
		}

		public string Name_Type
		{
			get
			{
				switch( Type )
				{
					case "bit"      : return "bool";
					case "char"     : return "string";
					case "varchar"  : return "string";
					case "nchar"    : return "string";
					case "nvarchar" : return "string";
					case "tinyint"  : return "byte";
					case "datetime" : return "DateTime";
					case "int"      : return "int";
					default : return "object";
				}
			}
		}

		public SQL_Field()
		{
		}
	}
}
