using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;

namespace MiddleTier
{
	public class SQL_Table
	{
		#region Sorter
		private class SQL_Table_Sorter : IComparer
		{
			public int Compare( object o1, object o2 )
			{
				SQL_Table t1 = (SQL_Table)o1;
				SQL_Table t2 = (SQL_Table)o2;

				// check dependencies
				foreach ( SQL_Constraint c1 in t1.Constraints )
					if ( c1.PKTABLE_NAME == t2.Name )
						return 1;

				foreach ( SQL_Constraint c2 in t2.Constraints )
					if ( c2.PKTABLE_NAME == t1.Name )
						return -1;

				return 0;
			}
		}
		public static IComparer Sort_Dependency
		{
			get
			{
				return new SQL_Table_Sorter();
			}
		}
		#endregion

		public string Name;

		public string           PK_NAME;
		public SQL_Field[]      Fields;
		public SQL_Constraint[] Constraints;

		public string Name_Collection
		{
			get
			{
				return string.Format( "h{0}", C_OVaria.ToProperCase_Parts( this.Name ) );
			}
		}

		public string Name_Type
		{
			get
			{
				return string.Format( "C{0}", C_OVaria.ToProperCase_Parts( this.Name ) );
			}
		}

		public SQL_Table()
		{
		}
	}
}
