using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;

namespace LogicImage
{
  public class CAboutForm : Form
  {
    Label  lD;
    public CAboutForm()
    {
      this.Size            = new Size( 350, 240 );
      this.FormBorderStyle = FormBorderStyle.FixedDialog;
      this.MaximizeBox     = this.MinimizeBox = false;  
      this.StartPosition   = FormStartPosition.CenterScreen;

      this.Text            = "About...";

      lD           = new Label();
      lD.Size      = new Size( this.ClientSize.Width, this.ClientSize.Height-70 );
      lD.Location  = new Point( 0, 40 );
      lD.TextAlign = ContentAlignment.MiddleCenter; 
      lD.Text      = "Numbers around the board should be used to find the hidden image. "+
                     "Each number means a block of consecutive cells "+
                     "that are separated from other blocks by a margin "+
                     "of at least one cell.\r\n\r\n"+
                     "Try to mark the cells that are occupied for sure and then "+
                     "deduce the position of other marked cells.\r\n\r\n"+
                     "Board data files are stored in XML format. Feel free to build "+
                     "your own puzzles.\r\n\r\nGood luck!";
      this.Controls.Add( lD );
    }

    protected override void OnPaint( PaintEventArgs e )
    {
      base.OnPaint( e );

      using ( FontFamily ft = new FontFamily( "Tahoma" ) )
      {
        StringFormat sf = new StringFormat();
        sf.Alignment    = sf.LineAlignment = StringAlignment.Center;

        Rectangle r     = new Rectangle( 0, 0, this.ClientRectangle.Width, 40 );
        GraphicsPath gp = new GraphicsPath();
        gp.AddString( "LogicImage.NET 1.0", ft, 1, 26, r, sf );

        r = new Rectangle( 0, ClientSize.Height-30, ClientRectangle.Width, 30 );
        gp.AddString( "Wiktor Zychla, IX.2003", ft, 1, 16, r, sf );

        e.Graphics.SmoothingMode = SmoothingMode.HighQuality;

        using ( LinearGradientBrush lgb = 
                new LinearGradientBrush( this.ClientRectangle, Color.Red, Color.Blue, 
                                         LinearGradientMode.BackwardDiagonal ) )
        {
           e.Graphics.FillPath( lgb, gp );
           e.Graphics.DrawPath( Pens.Black, gp );
        }
      }
    } 
  }  
}