using System;
using System.Drawing;
using System.Windows.Forms;

namespace UniversalGrabber
{
	public class CGrab
	{
		public static Bitmap GrabDesktop()
		{
			return GrabWindow( Win32.GetDesktopWindow(), false );
		}

		public static Bitmap GrabActiveWindow( bool bClientOnly )
		{
			return GrabWindow( Win32.GetForegroundWindow(), bClientOnly );
		}

		public static Bitmap GrabWindow( IntPtr hWnd, bool bClientOnly )
		{
			Win32.RECT s = new Win32.RECT();
			if ( bClientOnly )
				Win32.GetClientRect( hWnd, ref s );
			else
				Win32.GetWindowRect( hWnd, ref s );

			int X = s.right-s.left;
			int Y = s.bottom-s.top;

			IntPtr hDC = IntPtr.Zero;
			if ( bClientOnly )
				hDC = Win32.GetDC( hWnd );
			else
				hDC = Win32.GetWindowDC( hWnd );
			Graphics gDC      = Graphics.FromHdc( hDC );
			Bitmap bDesktop   = new Bitmap( X, Y, gDC );
			Graphics gDImage  = Graphics.FromImage( bDesktop );
			
			IntPtr hdc1  = gDC.GetHdc();
			IntPtr hdc2  = gDImage.GetHdc();
			Win32.BitBlt( hdc2, 0, 0, X, Y, hdc1, 0, 0, 0x00CC0020 );
			
			gDC.ReleaseHdc( hdc1 );
			gDImage.ReleaseHdc( hdc2 );
			Win32.ReleaseDC( hWnd, hDC );

			return bDesktop;
		}

		private CGrab() {}
	}
}
