using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace UniversalGrabber
{
	public class UnivGrab : System.Windows.Forms.Form
	{
		#region Konstrukcja, destrukcja
		const int F2_HOTKEY     = 100;
		const int CT_F2_HOTKEY  = 101; 
		const int ALT_F2_HOTKEY = 102; 

		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem mnuGrabDesktop;
		private System.Windows.Forms.MenuItem mnuGrabActive;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem mnuSaveAs;
		private CPictureBox pImage;
		private System.Windows.Forms.MenuItem mnuCopy;
		private System.Windows.Forms.MenuItem mnuPaste;
		private System.Windows.Forms.MenuItem mnuGrabActiveClient;
		private System.Windows.Forms.MenuItem mnuCut;
		private System.ComponentModel.IContainer components=null;

		public UnivGrab()
		{
			InitializeComponent();
			InitializeMyComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(UnivGrab));
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.mnuGrabDesktop = new System.Windows.Forms.MenuItem();
			this.mnuGrabActive = new System.Windows.Forms.MenuItem();
			this.mnuGrabActiveClient = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.mnuSaveAs = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.mnuCopy = new System.Windows.Forms.MenuItem();
			this.mnuPaste = new System.Windows.Forms.MenuItem();
			this.mnuCut = new System.Windows.Forms.MenuItem();
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItem1,
																					 this.menuItem2});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.mnuGrabDesktop,
																					  this.mnuGrabActive,
																					  this.mnuGrabActiveClient,
																					  this.menuItem4,
																					  this.mnuSaveAs});
			this.menuItem1.Text = "File";
			// 
			// mnuGrabDesktop
			// 
			this.mnuGrabDesktop.Index = 0;
			this.mnuGrabDesktop.Shortcut = System.Windows.Forms.Shortcut.F2;
			this.mnuGrabDesktop.Text = "Grab desktop";
			this.mnuGrabDesktop.Click += new System.EventHandler(this.mnuGrabDesktop_Click);
			// 
			// mnuGrabActive
			// 
			this.mnuGrabActive.Index = 1;
			this.mnuGrabActive.Shortcut = System.Windows.Forms.Shortcut.CtrlF2;
			this.mnuGrabActive.Text = "Grab active window";
			this.mnuGrabActive.Click += new System.EventHandler(this.mnuGrabActive_Click);
			// 
			// mnuGrabActiveClient
			// 
			this.mnuGrabActiveClient.Index = 2;
			this.mnuGrabActiveClient.Shortcut = System.Windows.Forms.Shortcut.AltF2;
			this.mnuGrabActiveClient.Text = "Grab client area of active window";
			this.mnuGrabActiveClient.Click += new System.EventHandler(this.mnuGrabActiveClient_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 3;
			this.menuItem4.Text = "-";
			// 
			// mnuSaveAs
			// 
			this.mnuSaveAs.Index = 4;
			this.mnuSaveAs.Text = "Save as...";
			this.mnuSaveAs.Click += new System.EventHandler(this.mnuSaveAs_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.mnuCopy,
																					  this.mnuPaste,
																					  this.mnuCut});
			this.menuItem2.Text = "Edit";
			// 
			// mnuCopy
			// 
			this.mnuCopy.Index = 0;
			this.mnuCopy.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
			this.mnuCopy.Text = "Copy";
			this.mnuCopy.Click += new System.EventHandler(this.mnuCopy_Click);
			// 
			// mnuPaste
			// 
			this.mnuPaste.Index = 1;
			this.mnuPaste.Shortcut = System.Windows.Forms.Shortcut.CtrlV;
			this.mnuPaste.Text = "Paste";
			this.mnuPaste.Click += new System.EventHandler(this.mnuPaste_Click);
			// 
			// mnuCut
			// 
			this.mnuCut.Index = 2;
			this.mnuCut.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
			this.mnuCut.Text = "Cut";
			this.mnuCut.Click += new System.EventHandler(this.mnuCut_Click);
			// 
			// UnivGrab
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.ControlDark;
			this.ClientSize = new System.Drawing.Size(464, 337);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.KeyPreview = true;
			this.Menu = this.mainMenu;
			this.Name = "UnivGrab";
			this.Text = "Universal Grabber";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
			this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.UnivGrab_KeyDown);
			this.Load += new System.EventHandler(this.UnivGrab_Load);
			this.Closed += new System.EventHandler(this.UnivGrab_Closed);

		}
		void InitializeMyComponent()
		{
			pImage             = new CPictureBox();
			pImage.Dock        = DockStyle.Fill;
			pImage.BorderStyle = BorderStyle.Fixed3D;
			this.Controls.Add( pImage );
		}
		#endregion
		#endregion
		#region Zdarzenia formy
		private void UnivGrab_Load(object sender, System.EventArgs e)
		{
			Win32.RegisterHotKey( this.Handle, F2_HOTKEY, Win32.KeyModifiers.None, Keys.F2 );
			Win32.RegisterHotKey( this.Handle, CT_F2_HOTKEY, Win32.KeyModifiers.Control, Keys.F2 );
			Win32.RegisterHotKey( this.Handle, ALT_F2_HOTKEY, Win32.KeyModifiers.Alt, Keys.F2 );
		}
		private void UnivGrab_Closed(object sender, System.EventArgs e)
		{
			Win32.UnregisterHotKey( this.Handle, F2_HOTKEY );		
			Win32.UnregisterHotKey( this.Handle, CT_F2_HOTKEY );		
			Win32.UnregisterHotKey( this.Handle, ALT_F2_HOTKEY );		
		}

		private void UnivGrab_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if ( (int)e.KeyCode == (int)Keys.Escape )
			{
				pImage.Reset();
			}
		}

		protected override void WndProc( ref Message m )
		{    
			switch( m.Msg )    
			{    
				case (int)Win32.Msg.WM_HOTKEY:                  
					ProcessHotkey( m.WParam.ToInt32() );
					break;    
			}     
			base.WndProc(ref m );
		}

		#endregion
		#region Kontrolki, menu
		private void ProcessHotkey( int hotKeyId )
		{				 
			switch ( hotKeyId )
			{
				case F2_HOTKEY     : mnuGrabDesktop_Click( null, null ); break;
				case CT_F2_HOTKEY  : mnuGrabActive_Click( null, null ); break;
				case ALT_F2_HOTKEY : mnuGrabActiveClient_Click( null, null ); break;
			}
		}
		private void mnuGrabDesktop_Click(object sender, System.EventArgs e)
		{
			pImage.Image = null;
			pImage.Image = CGrab.GrabDesktop();
			
			Activate();
			if ( this.WindowState == FormWindowState.Minimized ) this.WindowState = FormWindowState.Normal;
		}
		private void mnuGrabActive_Click(object sender, System.EventArgs e)
		{
			Dummy d = new Dummy();
			d.ShowDialog();
			
			IntPtr hWnd = Win32.WindowFromPoint( new Win32.POINT( d.SelectedPoint ) );
			if ( hWnd != IntPtr.Zero )
			{
				pImage.Image = null;
				pImage.Image = CGrab.GrabWindow( hWnd, false );

				Activate();
				if ( this.WindowState == FormWindowState.Minimized ) this.WindowState = FormWindowState.Normal;
			}
		}
		private void mnuGrabActiveClient_Click(object sender, System.EventArgs e)
		{
			Dummy d = new Dummy();
			d.ShowDialog();
			
			IntPtr hWnd = Win32.WindowFromPoint( new Win32.POINT( d.SelectedPoint ) );
			if ( hWnd != IntPtr.Zero )
			{
				pImage.Image = null;
				pImage.Image = CGrab.GrabWindow( hWnd, true );
				
				Activate();
				if ( this.WindowState == FormWindowState.Minimized ) this.WindowState = FormWindowState.Normal;
			}
		}
		public const string Pic_Filtr = "Dowolny plik graficzny (JPEG, GIF, BMP, etc.)|"+
			"*.jpg;*.jpeg;*.gif;*.bmp;*.png|"+
			"Plik JPEG (*.jpg;*.jpeg)|*.jpg;*.jpeg|"+
			"Plik GIF (*.gif)|*.gif|"+
			"Plik BMP (*.bmp)|*.bmp|"+
			"Plik PNG (*.png)|*.png|"+
			"Wszystkie pliki (*.*)|*.*";
		private void mnuSaveAs_Click(object sender, System.EventArgs e)
		{
			if ( pImage.Image != null )
			{
				SaveFileDialog sF  = new SaveFileDialog();
				sF.OverwritePrompt = true;
				sF.Title           = "Zapis...";
				sF.Filter          = Pic_Filtr;
				sF.FilterIndex     = 2;
 
				sF.ShowDialog( this );

				if ( sF.FileName != string.Empty )
				{
					if ( sF.FileName.EndsWith("jpg") )
						pImage.Image.Save ( sF.FileName, ImageFormat.Jpeg );
					else
						if ( sF.FileName.EndsWith("png") )
						pImage.Image.Save ( sF.FileName, ImageFormat.Png );
					else
						if ( sF.FileName.EndsWith("gif") )
						pImage.Image.Save ( sF.FileName, ImageFormat.Gif );
					else
						if ( sF.FileName.EndsWith("bmp") )
						pImage.Image.Save ( sF.FileName, ImageFormat.Bmp );
					else
						pImage.Image.Save ( sF.FileName, ImageFormat.Jpeg );
				}
			}
		}
		private void mnuCopy_Click(object sender, System.EventArgs e)
		{
			if ( pImage.Image != null )
			{
				Image iImage = null;
				if ( pImage.pStart != Point.Empty && pImage.pEnd != Point.Empty )
				{
					Rectangle rImage = CVaria.RectFromPoints( pImage.pStart, pImage.pEnd );
					if ( rImage.Width > 0 && rImage.Height > 0 )
					{
						iImage = new Bitmap( rImage.Size.Width, rImage.Size.Height );
						using ( Graphics g = Graphics.FromImage( iImage ) )
						{
							g.TranslateTransform( -rImage.X, -rImage.Y );
							g.DrawImageUnscaled( pImage.Image, 0, 0 );
						}
					}
				}
				else
					iImage = pImage.Image;

				if ( iImage != null )
					Clipboard.SetDataObject( iImage );
			}
		}

		private void mnuPaste_Click(object sender, System.EventArgs e)
		{
			IDataObject data = Clipboard.GetDataObject();		
			if ( data.GetDataPresent( typeof( System.Drawing.Bitmap ) ) )
			{
				pImage.Reset();
				pImage.Image = (Image)data.GetData( typeof( System.Drawing.Bitmap ) );
			}
		}

		private void mnuCut_Click(object sender, System.EventArgs e)
		{
			mnuCopy_Click( sender, e );
			mnuPaste_Click( sender, e );
		}
		#endregion		

	}
}
