using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime;
using System.Runtime.InteropServices; 

namespace vicMazeGen
{
	public class frmAbout : System.Windows.Forms.Form
	{
		private const int PSiz     = 128;

		private int    cx, cy;
		private double angle = 0.0, angle2 = 0.0;

		private Timer  locTimer;
		private bool   painting = false;
		private Bitmap picFracSource;

		private System.Windows.Forms.PictureBox picFrac;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;

		private System.ComponentModel.Container components = null;

		public frmAbout()
		{
			this.SetStyle(ControlStyles.DoubleBuffer, true);
			this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);

			picFracSource = new Bitmap( PSiz, PSiz, PixelFormat.Format24bppRgb );

			locTimer = new Timer();
			locTimer.Interval = 15;	// try fast!
			locTimer.Tick += new System.EventHandler(locTimer_Tick);

			InitializeComponent();

			locTimer.Enabled = true; 
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.picFrac = new System.Windows.Forms.PictureBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// picFrac
			// 
			this.picFrac.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.picFrac.Location = new System.Drawing.Point(4, 4);
			this.picFrac.Name = "picFrac";
			this.picFrac.Size = new System.Drawing.Size(400, 224);
			this.picFrac.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picFrac.TabIndex = 0;
			this.picFrac.TabStop = false;
			// 
			// label1
			// 
			this.label1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label1.Font = new System.Drawing.Font("Tahoma", 12F, (System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Italic), System.Drawing.GraphicsUnit.Point, ((System.Byte)(238)));
			this.label1.ForeColor = System.Drawing.Color.Red;
			this.label1.Location = new System.Drawing.Point(408, 4);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(96, 56);
			this.label1.TabIndex = 2;
			this.label1.Text = "TorqMaze 0.01";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label2
			// 
			this.label2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label2.Location = new System.Drawing.Point(408, 68);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(96, 160);
			this.label2.TabIndex = 3;
			this.label2.Text = "Wiktor Zychla, torq314@wp.pl";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// frmAbout
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(510, 235);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label2,
																		  this.label1,
																		  this.picFrac});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "frmAbout";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "About...";
			this.ResumeLayout(false);

		}
		#endregion
		#region Form controls events
		private void locTimer_Tick(object sender, EventArgs e)
		{
			angle += 0.023; angle2+= 0.027;
			cx = (int)( 800.0 * Math.Sin( angle+1.0 ) ); 
			cy = (int)( 800.0 * Math.Cos( angle2 ) );

			if ( painting == false )
			{
				painting = true;
				JuliaPaint();
				painting = false;
			}
		}
		#endregion
		#region FracPaint
		private void JuliaPaint()
		{

			Rectangle bounds = 
				new Rectangle( new Point(0, 0), 
				new Size( picFracSource.Width, picFracSource.Height ) ); 
			BitmapData bData = picFracSource.LockBits( bounds, ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb );

			byte[] picData = new byte[PSiz * PSiz * 3];
			int iDex = 0;

			int iterNo, i, j;
			int x, y, xn, yn, x2, y2;
			for (i=0; i<PSiz; i++ )
				for (j=0; j<PSiz; j++ )
				{
					iterNo = 0;
					x  = (i<<5)-2048; 
					y  = (j<<5)-2048;
					x2 = x*x;  
					y2 = y*y;
					while ( 
						( iterNo++ < 32 ) && 
						( Math.Abs(x2+y2) < 4000000 ) 
						)
					{
						x2 = x*x; y2 = y*y;
						xn = ((x2-y2)>>10) + cx;
						yn = ((x*y)>>9)    + cy;
						x  = xn; y  = yn;
					}

					picData[iDex++] = Convert.ToByte(255-iterNo);
					picData[iDex++] = Convert.ToByte(5*iterNo);
					picData[iDex++] = Convert.ToByte(5*iterNo);
				}

			Marshal.Copy ( picData, 0, bData.Scan0, PSiz * PSiz * 3 ); 

			picFracSource.UnlockBits( bData );
			this.picFrac.Image = picFracSource; 
			this.picFrac.Invalidate();
		}
		#endregion
	}
}
