// created on 2003-01-31 at 22:11

using System;
using System.Collections;
using System.Drawing;

namespace NTRILMA
{
	public class TrilmaMove
	{ 
	 	public Point srcPoint;
	 	public Point destPoint;
		
		private TrilmaMove() {}
		public TrilmaMove( Point SourcePoint, Point DestinationPoint) 
		{
			srcPoint  = SourcePoint;
			destPoint = DestinationPoint;
		}
				
		public override string ToString()
		{
			return String.Format( "[{0}-{1}]", srcPoint, destPoint );
		}
	}
	
	public class TrilmaMoveSequence 
	{
		public ArrayList Moves = new ArrayList();
		
		public int MoveValue( TrilmaBoard Board )
		{
			if ( Moves.Count > 0 )
			{
				// compute new board layout
				TrilmaMove fMove = (TrilmaMove)Moves[0];
				TrilmaMove lMove = (TrilmaMove)Moves[Moves.Count-1]; 
				
				Board.theBoard[ fMove.srcPoint.X, fMove.srcPoint.Y ].Piece = 
					TrilmaSquare.EMPTY;
				Board.theBoard[ lMove.destPoint.X, lMove.destPoint.Y].Piece = 
					Board.currentPlayer;
				
				TrilmaPlayer tPlayer = Board.trilmaPlayers[ Board.currentPlayer ];
				
				int i,j, iMult;
				int value = 0;
				for ( i=0; i<TrilmaBoard.BOARD_SIZE; i++ )
					for ( j=0; j<TrilmaBoard.BOARD_SIZE; j++ )
						if ( Board.theBoard[i,j].Piece == tPlayer.plNumber )
						{
							Point bPoint = new Point(i,j);

							foreach ( Point endPoint in tPlayer.plEndPos )
							{
								// add the bonus for empty squares (?)
								if ( Board.theBoard[endPoint.X, endPoint.Y].Piece == TrilmaSquare.EMPTY )
									iMult = 2;
								else
									iMult = 1;
								value -= iMult * Board.CalculateDistance( bPoint, endPoint );
							}
							value -= TrilmaBoard.NO_PLAYER_PCS * Board.CalculateDistance( bPoint, tPlayer.plEndPoint );
						}
						
				// restore old layout						
				Board.theBoard[ fMove.srcPoint.X, fMove.srcPoint.Y ].Piece = 
					Board.currentPlayer;
				Board.theBoard[ lMove.destPoint.X, lMove.destPoint.Y].Piece = 
					TrilmaSquare.EMPTY;
						
				return value;
			}
			else
				throw new Exception( "Empty move has no value!" );
		}
								
		public override string ToString()
		{
			string sRet = String.Empty;
			
			foreach ( TrilmaMove Move in Moves )
				sRet += Move.ToString()+",";
			
			return sRet;
		}

		public TrilmaMoveSequence( TrilmaMoveSequence oldSeq )
		{			
			// make a copy of all moves
			foreach ( TrilmaMove m in oldSeq.Moves )
				this.Moves.Add( m );
			
		}
		
		public TrilmaMoveSequence() {}
	}

	public class TrilmaMoveComparer : IComparer
	{
		TrilmaBoard theBoard;

		public TrilmaMoveComparer( TrilmaBoard theBoard )
		{
			this.theBoard = theBoard;
		}

		public static IComparer Comparer( TrilmaBoard theBoard )
		{
			return new TrilmaMoveComparer( theBoard );
		}

		public int Compare(object x, object y)
		{
			if ( x is TrilmaMoveSequence && y is TrilmaMoveSequence )
			{
				TrilmaMoveSequence move1 = (TrilmaMoveSequence)x;
				TrilmaMoveSequence move2 = (TrilmaMoveSequence)y;

				int move1value = move1.MoveValue( theBoard );
				int move2value = move2.MoveValue( theBoard );
				 
				if ( move1value != move2value )
					// the highest value, the better
					return move1value.CompareTo( move2value );
				else
				{
					// favour moves with most distant checkers
					int d1 = theBoard.CalculateDistance( ((TrilmaMove)move1.Moves[0]).srcPoint );
					int d2 = theBoard.CalculateDistance( ((TrilmaMove)move2.Moves[0]).srcPoint );

					// the more distant checker, the better
					if ( d1 != d2 )
					{
						int rval = MainClass.Random.Next()%10;
						return (rval<9 ? 1 : -1) * d1.CompareTo( d2 );
					}
					else
					{
						// return shortest move 
						return -move1.Moves.Count.CompareTo( move2.Moves.Count );
					}
				}
			}
			else
				return 0;
		}
	}

}
