using System;
using System.Collections;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;

namespace NTRILMA
{
	class f_TrilmaForm : System.Windows.Forms.Form
	{		
		private System.Windows.Forms.PictureBox pictureBox;
		const int BITMAP_X   = 512;
		const int BITMAP_Y   = 512;
		const string bkgFileName = "Trilma.jpg";

		// game: bitmap, thread				
		private Thread trilmaGameThread;
		private System.Drawing.Bitmap trilmaBitmap;	
		private System.Drawing.Bitmap trilmaBkg;	
		private TrilmaBoard trilmaBoard = new TrilmaBoard();
		
		// human move
		private bool humanTurn               = false; // is human going to move?
		private bool humanFinishedMoving     = false; // did human finished his move?
		
		private System.Windows.Forms.MainMenu mnuMainMenu;
		private System.ComponentModel.Container components = null;
		
		#region Construction, destruction
		public f_TrilmaForm()
		{
			SetStyle(ControlStyles.UserPaint, true);  
			SetStyle(ControlStyles.AllPaintingInWmPaint, true); 
			SetStyle(ControlStyles.DoubleBuffer, true); 
			
			InitializeComponent();
			InitializeCustomComponents();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		
		#region Windows Form Designer generated code		
		void InitializeCustomComponents()   
		{			
			mnuMainMenu = new System.Windows.Forms.MainMenu();			
			// Game
			MenuItem mnuGame = new MenuItem();
			mnuGame.Text = "Game";
			
			MenuItem mnuGameNew = new MenuItem();
			mnuGameNew.Text = "New";
			mnuGameNew.Click += new EventHandler( mnuGameNew_Click );
			mnuGame.MenuItems.Add( mnuGameNew );
			
			MenuItem mnuGameBreak1 = new MenuItem();
			mnuGameBreak1.Text = "-";
			mnuGame.MenuItems.Add( mnuGameBreak1 );
			
			MenuItem mnuGameExit = new MenuItem();
			mnuGameExit.Text = "Exit";
			mnuGameExit.Click += new EventHandler( mnuGameExit_Click );
			mnuGame.MenuItems.Add( mnuGameExit );
			
			mnuMainMenu.MenuItems.Add( mnuGame );
			
			//About						
			MenuItem mnuAbout = new MenuItem();
			mnuAbout.Text = "Help";
			
			MenuItem mnuHomePage = new MenuItem();
			mnuHomePage.Text = "Home page";
			mnuHomePage.Click += new EventHandler( mnuHomePage_Click );
			mnuAbout.MenuItems.Add( mnuHomePage );
			
			mnuAbout.MenuItems.Add( new MenuItem( "-" ) );
			
			MenuItem mnuAboutFrm = new MenuItem();
			mnuAboutFrm.Text = "About...";						
			mnuAboutFrm.Click += new EventHandler( mnuAbout_Click );
			mnuAbout.MenuItems.Add( mnuAboutFrm );
			
			mnuMainMenu.MenuItems.Add( mnuAbout );
			// Add the menu
		    this.Menu = mnuMainMenu;			
			// initialize bitmap
			trilmaBitmap = new Bitmap( BITMAP_X, BITMAP_Y, PixelFormat.Format24bppRgb );
			trilmaBkg    = new Bitmap( typeof(f_TrilmaForm).Assembly.GetManifestResourceStream( "NTRILMA."+bkgFileName ) );
		}
								
		void InitializeComponent() {
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(f_TrilmaForm));
			this.pictureBox = new System.Windows.Forms.PictureBox();
			this.SuspendLayout();
			// 
			// pictureBox
			// 
			this.pictureBox.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.pictureBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pictureBox.Location = new System.Drawing.Point(0, 0);
			this.pictureBox.Name = "pictureBox";
			this.pictureBox.Size = new System.Drawing.Size(512, 512);
			this.pictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox.TabIndex = 0;
			this.pictureBox.TabStop = false;
			this.pictureBox.MouseDown += new System.Windows.Forms.MouseEventHandler(this.pictureBoxMouseDown);
			// 
			// f_TrilmaForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 512);
			this.Controls.Add(this.pictureBox);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MinimumSize = new System.Drawing.Size(64, 64);
			this.Name = "f_TrilmaForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Trilma.NET 0.0.3";
			this.Closed += new System.EventHandler(this.f_TrilmaFormClosed);
			this.ResumeLayout(false);

		}
		#endregion				
		#endregion
		#region Game engine <-> Form
		void f_TrilmaFormClosed( object sender, System.EventArgs e )
		{
			StopCurrentGame();
		}
		void pictureBoxMouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ReadHumanMove( e );
			trilmaBitmap_Show();
		}
		void trilmaBitmap_ShowHelper()
		{
			// refresh bitmap image
			trilmaBoard.FillBoardBitmap( trilmaBitmap, trilmaBkg );
			// paint it 
			pictureBox.Image = trilmaBitmap;			
			this.pictureBox.Refresh();						
		}
		delegate void trilmaBitmap_ShowDelegate();
		void trilmaBitmap_Show()		
		{
			trilmaBitmap_ShowDelegate tbD = new trilmaBitmap_ShowDelegate( trilmaBitmap_ShowHelper );
			this.Invoke( tbD );
		}
		#endregion
		#region Menu handling
		void mnuGameExit_Click( object sender, EventArgs e )
		{
			Close();
		}
		void mnuGameNew_Click( object sender, EventArgs e )
		{
			StartNewGame();
		}
		void mnuHomePage_Click( object sender, EventArgs e )
		{
			ProcessStartInfo pi = new ProcessStartInfo();
			pi.UseShellExecute  = true;
			pi.FileName = "http://www.ii.uni.wroc.pl/~wzychla/torqt_en.html";
			
			Process.Start( pi );			
		}
		void mnuAbout_Click( object sender, EventArgs e )
		{
			(new f_TrilmaAbout()).ShowDialog();
		}
		#endregion
		#region Game
		void ReadHumanMove( System.Windows.Forms.MouseEventArgs e )
		{
			Point bP;
			
			// valid square?
			if ( humanTurn == false ) return;
			
			bP = trilmaBoard.BitmapPointToBoardPoint( pictureBox, e.X, e.Y );

			if ( bP.X < 0 || bP.X >= TrilmaBoard.BOARD_SIZE ||
			     bP.Y < 0 || bP.Y >= TrilmaBoard.BOARD_SIZE )
			     return;

			// if player piece clicked - reset the move
			if (
 			     trilmaBoard.theBoard[bP.X, bP.Y].Status == TrilmaSquareStatus.InsideBoard &&
  			     trilmaBoard.theBoard[bP.X, bP.Y].Piece  == trilmaBoard.currentPlayer
  			    )   
			{				
				TrilmaMove startPoint = new TrilmaMove( bP, bP );
				trilmaBoard.humanMove.Moves.Clear();
				trilmaBoard.humanMove.Moves.Add( startPoint );
			}
			else
			{
				if ( trilmaBoard.theBoard[bP.X, bP.Y].Status == TrilmaSquareStatus.InsideBoard &&
				     trilmaBoard.theBoard[bP.X, bP.Y].Piece  == TrilmaSquare.EMPTY &&
				     trilmaBoard.humanMove.Moves.Count > 0 )
				{
					TrilmaMove lastMove = (TrilmaMove)trilmaBoard.humanMove.Moves[trilmaBoard.humanMove.Moves.Count-1];
					// is the last move reclicked?
					if ( lastMove.destPoint.X == bP.X && lastMove.destPoint.Y == bP.Y )
					{
						if ( trilmaBoard.IsPlayerMoveValid() )
							humanFinishedMoving = true;
						else
							MessageBox.Show( "Invalid move!", "", MessageBoxButtons.OK, MessageBoxIcon.Error );
					}
					else
					{
						TrilmaMove nextMove = new TrilmaMove( lastMove.destPoint, bP );
						trilmaBoard.humanMove.Moves.Add( nextMove );
					}
				}
			}
		}
		void StopCurrentGame()
		{
			if ( trilmaGameThread != null )
				if ( trilmaGameThread.IsAlive )
				{
					trilmaGameThread.Abort();
					trilmaGameThread = null;
				}
		}
		bool SetupNewGame()
		{
			DialogResult res = (new f_TrilmaSetup( trilmaBoard )).ShowDialog();
			
			if ( res == DialogResult.OK )
			{
				this.trilmaBoard.InitializeBoard();
				return true;
			}
			else
				return false;
			
		}
		void StartNewGame()
		{
			StopCurrentGame();
			
			bool bPlay = SetupNewGame();
			
			if ( bPlay )
			{	
				ThreadStart trilmaThreadDelegate = new ThreadStart( PlayGame );
				trilmaGameThread = new System.Threading.Thread( trilmaThreadDelegate );				
				trilmaGameThread.Start();
			}			
		}
		void PlayGame()
		{
			TrilmaBoard.TrilmaBoardRefresh refreshBoardDelegate = new TrilmaBoard.TrilmaBoardRefresh( trilmaBitmap_Show ); 
			
			TrilmaMoveSequence tMoveList;
			while ( !trilmaBoard.L_GameFinished() )
			{		
				if ( !trilmaBoard.L_PlayerFinished( trilmaBoard.currentPlayer ) )
				{
					if ( trilmaBoard.trilmaPlayers[trilmaBoard.currentPlayer].plStatus ==
					     TrilmaPlayerStatus.Computer )
					{
						humanTurn = false;
						tMoveList = trilmaBoard.GetNextMove();
					}
					else
					{
						// get player move
						// wait until move is finished
						humanTurn           = true;
						humanFinishedMoving = false;
						
						trilmaBitmap_Show();
						
						while ( humanFinishedMoving == false ) 
							Thread.Sleep( 50 );

						// human move gathered
						tMoveList = new TrilmaMoveSequence( trilmaBoard.humanMove );
						trilmaBoard.humanMove.Moves.Clear();
					}
					trilmaBoard.MakeMove( tMoveList, refreshBoardDelegate );
				}
				trilmaBoard.ChangePlayer();			
			}
			trilmaBitmap_Show();
			MessageBox.Show( "Game finished!", "", MessageBoxButtons.OK, MessageBoxIcon.Information );
		}
		#endregion
	}
}
