using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Microsoft.DirectX.AudioVideoPlayback;

namespace DirectXTutorial
{
	public class DirectXAVForm : System.Windows.Forms.Form
	{
		Video video = null;
		Audio audio = null;

		Button bVPlay;
		Button bVStop;
		Button bAPlay;
		Button bAStop;

		public static void Main() 
		{		
			Application.Run(new DirectXAVForm());
		}

		public DirectXAVForm()
		{
            bVPlay       = new Button();
			bVPlay.Click += new EventHandler( VPlay_Click );
			bVPlay.Text  = "Otwrz plik video";
			bVPlay.Size  =  new Size( 100, 20 );
			bVPlay.Location = new Point( 10, 10 );

			bVStop       = new Button();
			bVStop.Click += new EventHandler( VStop_Click );
			bVStop.Text  = "Stop video";
			bVStop.Size  =  new Size( 100, 20 );
			bVStop.Location = new Point( 10, 40 );

            bAPlay       = new Button();
			bAPlay.Click += new EventHandler( APlay_Click );
			bAPlay.Text  = "Otwrz plik audio";
			bAPlay.Size  =  new Size( 100, 20 );
			bAPlay.Location = new Point( 10, 70 );

			bAStop       = new Button();
			bAStop.Click += new EventHandler( AStop_Click );
			bAStop.Text  = "Stop audio";
			bAStop.Size  =  new Size( 100, 20 );
			bAStop.Location = new Point( 10, 100 );

			this.Controls.Add( bVPlay );
			this.Controls.Add( bVStop );
			this.Controls.Add( bAPlay );
			this.Controls.Add( bAStop );

			this.ClientSize = new System.Drawing.Size(292, 273);
			this.Name = "Audio/Video player";
			this.Text = "Audio/Video player";
		}

		private void VPlay_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog of = new OpenFileDialog();
			of.ShowDialog( this );

			if ( of.FileName != String.Empty )
			{
				video       = Video.FromFile(of.FileName);
				video.Owner = this;
				video.Play();				
			}			
		}

		private void VStop_Click(object sender, System.EventArgs e)
		{
			if ( video != null ) video.Stop();		
		}

		private void APlay_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog of = new OpenFileDialog();
			of.ShowDialog( this );

			if ( of.FileName != String.Empty )
			{
				audio = Audio.FromFile(of.FileName);
				audio.Play();				
			}			
		}

		private void AStop_Click(object sender, System.EventArgs e)
		{
			if ( audio != null ) audio.Stop();		
		}
	}
}
