using System;
using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.DirectX;
using Microsoft.DirectX.DirectDraw;

namespace DirectXTutorial
{
    public class DirectDrawForm : System.Windows.Forms.Form
    {        
        private Device  draw      = null; 
        private Surface primary   = null; 
        private Clipper clip      = null; 

		static void Main() 
		{
			Application.Run(new DirectDrawForm());
		}

        public DirectDrawForm()
        {
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Name = "DirectDraw w oknie";
			this.Text = "DirectDraw w oknie";
			this.Resize      += new System.EventHandler(this.DDForm_SizeChanged);
			this.SizeChanged += new System.EventHandler(this.DDForm_SizeChanged);
			this.Paint       += new System.Windows.Forms.PaintEventHandler(this.DDForm_Paint);

            draw = new Device(); 
            draw.SetCooperativeLevel(this, CooperativeLevelFlags.Normal); 
            CreateSurfaces(); 
		}

        private void DDForm_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
        {
            Draw();
        }
        
        private void DDForm_SizeChanged(object sender, System.EventArgs e)
        {
            Draw();
        }
        
        private void Draw()
        {
            if ( primary == null ) return;           
            if ( WindowState == FormWindowState.Minimized ) return;
            			
			Point p = this.PointToScreen( new Point( 0, 0 ) );
			primary.ColorFill( Color.Blue );
			primary.ForeColor = Color.White;
			primary.DrawText( p.X, p.Y, "Pierwszy program w DirectX.NET", false );
		}
                                
        private void CreateSurfaces()
        {
            SurfaceDescription description = new SurfaceDescription(); 

            description.SurfaceCaps.PrimarySurface = true; 
            primary     = new Surface(description, draw); 
            clip        = new Clipper(draw); 
            clip.Window = this; 
            primary.Clipper = clip; 
        }
    }
}
