using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace NTRILMA
{
	public class GraphUtil
	{
		private GraphUtil() {}

		[DllImport("coredll")]
		public static extern int GetWindowLongW ( int hwnd, int nIndex );
		[DllImport("coredll")]
		public static extern int SetWindowLongW ( int hwnd, int nIndex, int dwNewLong );
		[DllImport("CoreDll")]
		public static extern IntPtr FindWindow(string className,string WindowsName);

		public static IntPtr Hwnd( Form f )
		{
			return FindWindow(null, f.Text);
		}

		public static Rectangle Rectangle( RectangleF rect )
		{
			return new Rectangle( (int)rect.X, (int)rect.Y, (int)rect.Width, (int)rect.Height );
		}
	}
}
