using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Threading;

namespace NTRILMA
{
	public class f_TrilmaForm : System.Windows.Forms.Form
	{
		const int BITMAP_X   = 256;
		const int BITMAP_Y   = 256;

		private Thread trilmaGameThread;
		private System.Drawing.Bitmap trilmaBitmap;	
		private System.Drawing.Bitmap trilmaBkg;	
		private TrilmaBoard trilmaBoard = new TrilmaBoard();

		private bool humanTurn               = false;
		private bool humanFinishedMoving     = false;
		private bool endGame				 = false;

		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem mnuNewGame;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem mnuAbout;
		private System.Windows.Forms.MenuItem mnuExit; // is human going to move?
	
		public f_TrilmaForm()
		{			
			InitializeComponent();
			InitializeCustomComponents();
		}

		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		void InitializeCustomComponents()   
		{	
			// initialize bitmap
			trilmaBitmap = new Bitmap( BITMAP_X, BITMAP_Y );
			Graphics gW = Graphics.FromImage( trilmaBitmap );
			gW.FillRectangle( Brushes.White, 0, 0, trilmaBitmap.Width, trilmaBitmap.Height );
			gW.Dispose();

			System.Reflection.Assembly aS = typeof(f_TrilmaForm).Assembly;
			trilmaBkg    = new Bitmap( aS.GetManifestResourceStream( "NTRILMA.Trilma.jpg" ) );
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(f_TrilmaForm));
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.mnuNewGame = new System.Windows.Forms.MenuItem();
			this.mnuExit = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.mnuAbout = new System.Windows.Forms.MenuItem();
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.Add(this.menuItem1);
			// 
			// menuItem1
			// 
			this.menuItem1.MenuItems.Add(this.mnuNewGame);
			this.menuItem1.MenuItems.Add(this.mnuExit);
			this.menuItem1.MenuItems.Add(this.menuItem2);
			this.menuItem1.MenuItems.Add(this.mnuAbout);
			this.menuItem1.Text = "Game";
			// 
			// mnuNewGame
			// 
			this.mnuNewGame.Text = "New";
			this.mnuNewGame.Click += new System.EventHandler(this.mnuNewGame_Click);
			// 
			// mnuExit
			// 
			this.mnuExit.Text = "Exit";
			this.mnuExit.Click += new System.EventHandler(this.mnuExit_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Text = "-";
			// 
			// mnuAbout
			// 
			this.mnuAbout.Text = "About...";
			this.mnuAbout.Click += new System.EventHandler(this.mnuAbout_Click);
			// 
			// f_TrilmaForm
			// 
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Menu = this.mainMenu;
			this.MinimizeBox = false;
			this.Text = "Pocket Trilma.NET";
			this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.f_TrilmaForm_MouseDown);
			this.Load += new System.EventHandler(this.f_TrilmaForm_Load);
			this.Closed += new System.EventHandler(this.f_TrilmaForm_Closed);

		}
		#endregion

		private void f_TrilmaForm_Closed(object sender, System.EventArgs e)
		{
			StopCurrentGame();				
		}
		private void f_TrilmaForm_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ReadHumanMove( e );
			trilmaBitmap_Show();		
		}
		void trilmaBitmap_ShowHelper()
		{
			// refresh bitmap image
			trilmaBoard.FillBoardBitmap( trilmaBitmap, trilmaBkg );
			// paint it 
			this.Invalidate();
		}
		delegate void trilmaBitmap_ShowDelegate();
		void trilmaBitmap_Show()		
		{
			trilmaBitmap_ShowHelper();
		}

		protected override void OnPaintBackground(PaintEventArgs e)
		{
//			if ( trilmaBitmap == null )
//				base.OnPaintBackground( e );
		}

		protected override void OnPaint( System.Windows.Forms.PaintEventArgs e )
		{
			e.Graphics.DrawImage( trilmaBitmap, this.ClientRectangle, new Rectangle( 0, 0, trilmaBitmap.Width, trilmaBitmap.Height ), GraphicsUnit.Pixel );
		}

		private void mnuNewGame_Click(object sender, System.EventArgs e)
		{
			StartNewGame();	
		}

		private void mnuExit_Click(object sender, System.EventArgs e)
		{
			Close();
		}
		#region Game
		void ReadHumanMove( System.Windows.Forms.MouseEventArgs e )
		{
			Point bP;
			
			// valid square?
			if ( humanTurn == false ) return;
			
			bP = trilmaBoard.BitmapPointToBoardPoint( this.Width, this.Height, e.X, e.Y );

			if ( bP.X < 0 || bP.X >= TrilmaBoard.BOARD_SIZE ||
				bP.Y < 0 || bP.Y >= TrilmaBoard.BOARD_SIZE )
				return;

			// if player piece clicked - reset the move
			if (
				trilmaBoard.theBoard[bP.X, bP.Y].Status == TrilmaSquareStatus.InsideBoard &&
				trilmaBoard.theBoard[bP.X, bP.Y].Piece  == trilmaBoard.currentPlayer
				)   
			{				
				TrilmaMove startPoint = new TrilmaMove( bP, bP );
				trilmaBoard.humanMove.Moves.Clear();
				trilmaBoard.humanMove.Moves.Add( startPoint );
			}
			else
			{
				if ( trilmaBoard.theBoard[bP.X, bP.Y].Status == TrilmaSquareStatus.InsideBoard &&
					trilmaBoard.theBoard[bP.X, bP.Y].Piece  == TrilmaSquare.EMPTY &&
					trilmaBoard.humanMove.Moves.Count > 0 )
				{
					TrilmaMove lastMove = (TrilmaMove)trilmaBoard.humanMove.Moves[trilmaBoard.humanMove.Moves.Count-1];
					// is the last move reclicked?
					if ( lastMove.destPoint.X == bP.X && lastMove.destPoint.Y == bP.Y )
					{
						if ( trilmaBoard.IsPlayerMoveValid() )
							humanFinishedMoving = true;
						else
							MessageBox.Show( "Invalid move!", "", MessageBoxButtons.OK, MessageBoxIcon.Asterisk, MessageBoxDefaultButton.Button1 );
					}
					else
					{
						TrilmaMove nextMove = new TrilmaMove( lastMove.destPoint, bP );
						trilmaBoard.humanMove.Moves.Add( nextMove );
					}
				}
			}
		}
		void StopCurrentGame()
		{
			if ( trilmaGameThread != null )
			{			
			    endGame          = true;
				trilmaGameThread = null;
			}
		}
		bool SetupNewGame()
		{
			this.trilmaBoard.trilmaPlayers[0].plStatus = TrilmaPlayerStatus.Human;
			this.trilmaBoard.trilmaPlayers[1].plStatus = TrilmaPlayerStatus.Computer;
			this.trilmaBoard.trilmaPlayers[2].plStatus = TrilmaPlayerStatus.Computer;
			this.trilmaBoard.trilmaPlayers[3].plStatus = TrilmaPlayerStatus.Computer;
			this.trilmaBoard.trilmaPlayers[4].plStatus = TrilmaPlayerStatus.Computer;
			this.trilmaBoard.trilmaPlayers[5].plStatus = TrilmaPlayerStatus.Computer;

			this.trilmaBoard.InitializeBoard();
			return true;			
		}
		void StartNewGame()
		{
			StopCurrentGame();		

			bool bPlay = SetupNewGame();
			
			if ( bPlay )
			{	
				ThreadStart trilmaThreadDelegate = new ThreadStart( PlayGame );
				trilmaGameThread = new System.Threading.Thread( trilmaThreadDelegate );				
				trilmaGameThread.Start();
			}			
		}
		void PlayGame()
		{
			TrilmaBoard.TrilmaBoardRefresh refreshBoardDelegate = new TrilmaBoard.TrilmaBoardRefresh( trilmaBitmap_Show ); 
			
			TrilmaMoveSequence tMoveList;
			while ( !trilmaBoard.L_GameFinished() )
			{		
				if ( endGame ) return;

				if ( !trilmaBoard.L_PlayerFinished( trilmaBoard.currentPlayer ) )
				{
					if ( trilmaBoard.trilmaPlayers[trilmaBoard.currentPlayer].plStatus ==
						TrilmaPlayerStatus.Computer )
					{
						humanTurn = false;
						tMoveList = trilmaBoard.GetNextMove();
					}
					else
					{
						// get player move
						// wait until move is finished
						humanTurn           = true;
						humanFinishedMoving = false;
						
						trilmaBitmap_Show();
						
						while ( humanFinishedMoving == false && endGame == false ) 
							Thread.Sleep( 0 );

						// human move gathered
						tMoveList = new TrilmaMoveSequence( trilmaBoard.humanMove );
						trilmaBoard.humanMove.Moves.Clear();
					}
					trilmaBoard.MakeMove( tMoveList, refreshBoardDelegate );
				}
				trilmaBoard.ChangePlayer();			
			}
			trilmaBitmap_Show();
			MessageBox.Show( "Game finished!", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1 );
		}
		#endregion

		private void f_TrilmaForm_Load(object sender, System.EventArgs e)
		{
			//IntPtr hwnd = GraphUtil.Hwnd( this );
			//GraphUtil.SetWindowLongW( hwnd.ToInt32(), -16, GraphUtil.GetWindowLongW(hwnd.ToInt32(), -16) + 65536 );
		}

		private void mnuAbout_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show( "Pocket Trilma.NET\r\nWiktor Zychla (c) 2004", "About...", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1 );
		}
	}
}
