/* Wiktor Zychla, 2003 */
using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.Serialization.Formatters.Soap;

namespace NExample
{
  [Serializable()]
  public class CObiekt 
  {
    int      v;
    DateTime d;
    string   s;
	 
    public CObiekt( int v, DateTime d, string s )
    {
      this.v = v; this.d = d; this.s = s;
    }
    
    public override string ToString()
    {
      return String.Format( "{0}, {1:d}, {2}", v, d, s );
    }
  }

  public class CMain
  {
    static void SerializujSOAP()
    {
      Console.WriteLine( "Serializacja SOAP" );

      CObiekt o = new CObiekt( 5, DateTime.Now, "Ala ma kota" );
      Console.WriteLine( o );

      // serializuj
      Stream          s = File.Create( "binary.soap" );
      SoapFormatter   b = new SoapFormatter();
      b.Serialize( s, o );
      s.Close();

      // deserializuj
      Stream          t = File.Open( "binary.soap", FileMode.Open );
      SoapFormatter   c = new SoapFormatter();
      CObiekt         p = (CObiekt)c.Deserialize( t );
      t.Close();

      Console.WriteLine( "Po deserializacji: " + p.ToString() );

    }

    public static void Main()
    {
      SerializujSOAP();
    }
  }
}
