/* Wiktor Zychla, 2003 */
using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.Serialization.Formatters.Soap;

namespace NExample
{
  [Serializable()]
  public class CObiekt : ISerializable
  {
    int      v;
    DateTime d;
    string   s;
	 
    public CObiekt( int v, DateTime d, string s )
    {
      this.v = v; this.d = d; this.s = s;
    }

    // konstruktor do deserializacji
    public CObiekt(SerializationInfo info, StreamingContext context) 
    {
      v = (int)info.GetValue("v", typeof(int));
      d = (DateTime)info.GetValue("d", typeof(DateTime));
      s = (string)info.GetValue("s", typeof(string));
    }


    // serializacja
    public void GetObjectData(SerializationInfo info, 
                              StreamingContext context)
    {
      info.AddValue("v", v);
      info.AddValue("d", d);
      info.AddValue("s", s);
    }
    
    public override string ToString()
    {
      return String.Format( "{0}, {1:d}, {2}", v, d, s );
    }
  }

  public class CMain
  {
    static void SerializujBinarnie()
    {
      Console.WriteLine( "Serializacja binarna" );

      CObiekt o = new CObiekt( 5, DateTime.Now, "Ala ma kota" );
      Console.WriteLine( o );

      // serializuj
      Stream          s = File.Create( "binary.dat" );
      BinaryFormatter b = new BinaryFormatter();
      b.Serialize( s, o );
      s.Close();

      // deserializuj
      Stream          t = File.Open( "binary.dat", FileMode.Open );
      BinaryFormatter c = new BinaryFormatter();
      CObiekt         p = (CObiekt)c.Deserialize( t );
      t.Close();

      Console.WriteLine( "Po deserializacji: " + p.ToString() );
    }

    public static void Main()
    {
      SerializujBinarnie();
    }
  }
}
