

#include <windows.h>			
#include <GL/gl.h>			
#include <GL/glu.h>			
#include <GL/glut.h>			
#include <stdio.h>
#include <stdlib.h>

#include "texture.h"

#define  PALETA_KOLOROW 32
#define  PELNY_EKRAN_X  800
#define  PELNY_EKRAN_Y  600

// tylko VisualC++! dziki temu nie trzeba ustawia
// bibliotek w opcjach projektu
#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "glut32.lib")

enum { 
    PAN = 1,				
    ROTATE,				
    ZOOM				
};


HDC hDC;				
GLfloat trans[3];			
GLfloat rot[2];				

GLuint texture1, texture2;
BOOL  bFullScreen = TRUE;

static void update(int state, int ox, int nx, int oy, int ny)
{
    int dx = ox - nx;
    int dy = ny - oy;

    switch(state) {
    case PAN:
	trans[0] -= dx / 100.0f;
	trans[1] -= dy / 100.0f;
	break;
    case ROTATE:
	rot[0] += (dy * 180.0f) / 500.0f;
	rot[1] -= (dx * 180.0f) / 500.0f;
#define clamp(x) x = x > 360.0f ? x-360.0f : x < -360.0f ? x+=360.0f : x
	clamp(rot[0]);
	clamp(rot[1]);
	break;
    case ZOOM:
	trans[2] -= (dx+dy) / 100.0f;
	break;
    }
}

void LoadAllTextures()
{
    int res = 0;

    // wczytaj wszystkie tekstury
    glNewList( texture1 = glGenLists(1), GL_COMPILE );
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);    
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);    
    res += TextureLoadBitmap("texture1.bmp");
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glEndList();

    glNewList( texture2 = glGenLists(1), GL_COMPILE );
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);    
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);    
    res += TextureLoadBitmap("texture2.bmp");
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glEndList();
    
    if (res) MessageBox(NULL, "Bd wczytywania tekstur.", "", MB_OK);
}

void
reshape(int width, int height)
{
    GLfloat nRange = 4.0;

    glViewport(0, 0, width, height);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
    gluPerspective(60.0, (float)width/height, 0.001, 100.0);
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    gluLookAt(0.0, 0.0, nRange-1,
              0.0, 0.0, 0.0,
              0.0, 1.0, 0.0);
              
}

#define TOP glVertex3i(0, 1, 0)
#define FR  glVertex3i(1, -1, 1)
#define FL  glVertex3i(-1, -1, 1)
#define BR  glVertex3i(1, -1, -1)
#define BL  glVertex3i(-1, -1, -1)

/*
		glBlendFunc(GL_ONE, GL_ZERO); jest odpowiednikiem wyczenia blendingu
		(do obrazu trafiaj tylko punkty z obrazu rdowego)

        glBlendFunc(GL_ONE, GL_ONE);  to zwyka przezroczysto	

		uwaga! blending dziaa poprawnie na prymitywach rysowanych w kolejnosci
		od najdalszego do najbliszego. dlatego prymitywy powinny by wstpnie 
		posortowane aby mona byo utworzy efekt prymityww bdcych przezroczystymi
		dla siebie nawzajem
*/
	
void
display()
{
    GLfloat diffuseLight[]={1.0f, 0.9f, 0.7f, 1.0f};
    GLfloat lightPos[]={4.0f, 5.0f, 10.0f, 0.0f};

    glEnable(GL_TEXTURE_2D);
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
    
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    glEnable(GL_BLEND);

	glBlendFunc(GL_ONE, GL_ONE);

    glPushMatrix();

    glTranslatef(trans[0], trans[1], trans[2]);
    glRotatef(rot[0], 1.0f, 0.0f, 0.0f);
    glRotatef(rot[1], 0.0f, 1.0f, 0.0f);

    glCallList(texture2);
	glBegin(GL_TRIANGLES);
    glTexCoord2f(0.0f, 0.0f); FR; 
    glTexCoord2f(1.0f, 0.0f); FL; 
    glTexCoord2f(1.0f, 1.0f); BL;
    
    glTexCoord2f(1.0f, 1.0f); BL; 
    glTexCoord2f(0.0f, 1.0f); BR; 
    glTexCoord2f(0.0f, 0.0f); FR;    
    glEnd();

    glCallList(texture1);
	glBegin(GL_TRIANGLES);

    glTexCoord2f(0.0f, 0.0f); TOP; 
	glTexCoord2f(0.0f, 1.0f); BR;
    glTexCoord2f(1.0f, 1.0f); FR; 

    glTexCoord2f(0.0f, 0.0f); TOP; 
	glTexCoord2f(1.0f, 0.0f); FL; 
    glTexCoord2f(1.0f, 1.0f); FR;
	
    glEnd();

    glPopMatrix();    

	glDisable(GL_TEXTURE_2D);

	glEnable(GL_LIGHTING);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT0, GL_POSITION, lightPos);
	glEnable(GL_LIGHT0);
		
	glDisable(GL_BLEND);
	glDisable(GL_LIGHTING);

    glFinish();
    SwapBuffers(hDC);			
}


LONG WINAPI
WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ 
    static PAINTSTRUCT ps;
    static GLboolean left  = GL_FALSE;	
    static GLboolean right = GL_FALSE;	
    static GLuint    state   = 0;	
    static int omx, omy, mx, my;
    static HGLRC hRC;				
    
	PIXELFORMATDESCRIPTOR pfd;
    HDC    hDC ;
    int    pf;
    
    switch(uMsg) {

    case WM_CREATE:

	    hDC = GetDC(hWnd);

	    memset(&pfd, 0, sizeof(pfd));
		pfd.nSize        = sizeof(pfd);
		pfd.nVersion     = 1;
		pfd.dwFlags      = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
		pfd.iPixelType   = PFD_TYPE_RGBA;
		pfd.cDepthBits   = PALETA_KOLOROW;
		pfd.cColorBits   = PALETA_KOLOROW;

	    pf = ChoosePixelFormat(hDC, &pfd);
	    if (pf == 0) {
			MessageBox(NULL, "Bd ustawiania formatu pixeli.",
				"Bad", MB_OK); 
			return 0;
		} 
 
		if (SetPixelFormat(hDC, pf, &pfd) == FALSE) {
			MessageBox(NULL, "SetPixelFormat() zakoczone bdem.",
				    "Bd", MB_OK);
		return 0;
		} 

		DescribePixelFormat(hDC, pf, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

		hRC = wglCreateContext(hDC);
		wglMakeCurrent(hDC, hRC);

		ReleaseDC(hWnd, hDC);

		LoadAllTextures();

		return 0;
    
    case WM_PAINT:
		display();
		BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		return 0;

    case WM_SIZE:
		if (!bFullScreen) 
		{
			reshape(LOWORD(lParam), HIWORD(lParam));
			PostMessage(hWnd, WM_PAINT, 0, 0);
		}
		return 0;

    case WM_CHAR:
		switch (wParam) {
			case 27:			
			PostQuitMessage(0);
			break;
		}
		return 0;

    case WM_LBUTTONDOWN:
    case WM_RBUTTONDOWN:

		SetCapture(hWnd);
		mx = LOWORD(lParam);
		my = HIWORD(lParam);
		if (uMsg == WM_LBUTTONDOWN)
		    state |= PAN;
		if (uMsg == WM_RBUTTONDOWN)
			state |= ROTATE;
		return 0;

    case WM_LBUTTONUP:
    case WM_RBUTTONUP:
		ReleaseCapture();
		state = 0;
		return 0;

    case WM_MOUSEMOVE:
		if (state) {
		    omx = mx;
			omy = my;
			mx = LOWORD(lParam);
			my = HIWORD(lParam);
			/* Win32 'gupieje' przy zwracaniu pozycji myszy
			opza lew lub grn krawdzi okna. 
			Dlatego naley warto bez znaku z przedziau
			0..2^16 przeksztaci do wartoci ze znakiem
			z przedziau 0..+/-2^15. */
			if(mx & 1 << 15) mx -= (1 << 16);
			if(my & 1 << 15) my -= (1 << 16);
			update(state, omx, mx, omy, my);
			PostMessage(hWnd, WM_PAINT, 0, 0);
		}
		return 0;

    case WM_DESTROY:
		if(bFullScreen)										
		{
			ChangeDisplaySettings(NULL,0);					
			ShowCursor(TRUE);								
		}
		return 0; 

    case WM_CLOSE:
    
		wglMakeCurrent(NULL, NULL);
		wglDeleteContext(hRC);

		PostQuitMessage(0);
		return 0;
	}

    return DefWindowProc(hWnd, uMsg, wParam, lParam); 
} 

void ChangeToFullScreen()
{
	int result;
	DEVMODE dmSettings;

	memset(&dmSettings,0,sizeof(dmSettings));			

	if(!EnumDisplaySettings(NULL,ENUM_CURRENT_SETTINGS,&dmSettings))
	{
		MessageBox(NULL, "Nie mona pobra informacji o rozdzielczoci.", "Bd", MB_OK);
		return;
	}

	dmSettings.dmPelsWidth	= PELNY_EKRAN_X;			
	dmSettings.dmPelsHeight	= PELNY_EKRAN_Y;		

	// tutaj nastpuje prba zmiany rozdzielczoci przy jednoczesnym
	// ustawieniu trybu penoekranowego
	result = ChangeDisplaySettings(&dmSettings,CDS_FULLSCREEN);	

	if(result != DISP_CHANGE_SUCCESSFUL)
	{
		MessageBox(NULL, "Nie mona ustawi zadaniej rozdzielczoci.", "Bd", MB_OK);
		PostQuitMessage(0);
	}
}

HWND
CreateOpenGLWindow(char* title, int x, int y, int width, int height, BOOL bFS)
{
    HWND        hWnd;
    WNDCLASS    wc;
	DWORD		dwStyle;
	RECT		rect;
    static HINSTANCE hInstance = 0;

    if (!hInstance) {
	hInstance        = GetModuleHandle(NULL);
	wc.style         = CS_OWNDC;
	wc.lpfnWndProc   = (WNDPROC)WindowProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon(NULL, IDI_WINLOGO);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = "OpenGL";

	if (!RegisterClass(&wc)) {
	    MessageBox(NULL, "RegisterClass() zakoczobne bdem.",
		         "Bd", MB_OK);
	    return NULL;
	}
    }

	if (bFS)
    { 
		dwStyle = WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
		ShowCursor(FALSE);		
		ChangeToFullScreen();	
    }
	else
        dwStyle = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

    hWnd = CreateWindow("OpenGL", title, dwStyle,
		   x, y, width, height, NULL, NULL, hInstance, NULL);

    if (hWnd == NULL) {
	MessageBox(NULL, "Bd tworzenia okna",
		   "Bd", MB_OK);
	return NULL;
    }

	// ju po utworzeniu okna upewnijmy si e ustawiamy poprawne parametry widoku
	if (bFS)
	{
		GetClientRect(hWnd, &rect);
		reshape(rect.right, rect.bottom);
	}

    return hWnd;
}    

int WINAPI WinMain(HINSTANCE hCurrentInst, HINSTANCE hPreviousInst,
	LPSTR lpszCmdLine, int nCmdShow)
{
    HWND  hWnd;				
    MSG   msg;			
    DWORD buffer = PFD_DOUBLEBUFFER;	
    BYTE  color  = PFD_TYPE_RGBA;	

	if (MessageBox(NULL, "Czy uruchomi program na penym ekranie?", 
		                 "", MB_YESNO | MB_ICONQUESTION)==IDNO)
       bFullScreen = FALSE;

    hWnd = CreateOpenGLWindow("Przezroczysto...", 
		           0, 0, PELNY_EKRAN_X, PELNY_EKRAN_Y, bFullScreen);
    if (hWnd == NULL)
	exit(1);

    hDC = GetDC(hWnd);

    glEnable(GL_DEPTH_TEST);

    ShowWindow(hWnd, nCmdShow);

    while(GetMessage(&msg, hWnd, 0, 0)) {
  		TranslateMessage(&msg);
		DispatchMessage(&msg);
    }

    DestroyWindow(hWnd);

    return msg.wParam;
}

