using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace WebApplication7
{
	/// <summary>
	/// Summary description for AjaxExample.
	/// </summary>
	public class AjaxExample : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DropDownList DropDownList1;
		protected System.Web.UI.WebControls.DropDownList DropDownList2;
		protected System.Web.UI.WebControls.DropDownList DropDownList3;
		protected System.Web.UI.WebControls.Button Button1;
		protected System.Web.UI.WebControls.Button Button2;
		protected System.Web.UI.WebControls.DropDownList DropDownList4;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if ( this.IsCallback() )
				return;

			if ( !this.IsPostBack )
			{
				InitializeCountries( DropDownList1 );
				InitializeCountries( DropDownList3 );
			}

			// zdarzenie client-side dla AJAX
			DropDownList3.Attributes["onchange"] = "FillCityList()";
		}

		/// <summary>
		/// W przypadku Callbacku do tej samej strony,
		/// callback mona odrni od zwykego PostBack jakkolwiek,
		/// byleby sposb odrniania by ustalony.
		/// 
		/// W tym przypadku: QueryString
		/// </summary>
		/// <returns></returns>
		bool IsCallback()
		{
			if ( Request.QueryString["AJAX"] != null )
			{
				string kraj = Request.QueryString["COUNTRY"];
				if ( kraj != null )
				{
					Response.Clear();
					Response.Write( Logic.GetCityListAJAX( kraj ) );
					Response.Flush();
					Response.End();

					return true;
				}
			}

			return false;
		}

		void InitializeCountries( DropDownList dropDownList )
		{
			string[] countries = { "Polska", "Niemcy", "Francja", "USA" };
			foreach ( string country in countries )
				dropDownList.Items.Add( country );
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.DropDownList1.SelectedIndexChanged += new System.EventHandler(this.DropDownList1_SelectedIndexChanged);
			this.Button1.Click += new System.EventHandler(this.Button1_Click);
			this.Button2.Click += new System.EventHandler(this.Button2_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		/// <summary>
		/// Bez AJAXa logika zmiany danych oprogramowania po stronie serwera.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DropDownList1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ( DropDownList1.SelectedItem != null )
			{
				DropDownList2.Items.Clear();

				foreach ( string item in Logic.GetCityList( DropDownList1.SelectedItem.Text ) )
				{
					DropDownList2.Items.Add( item );
				}
			}
		}

		private void Button1_Click(object sender, System.EventArgs e)
		{
			if ( DropDownList2.SelectedItem != null )
				Response.Write( DropDownList2.SelectedValue );
		}

		private void Button2_Click(object sender, System.EventArgs e)
		{
			// uwaga! tak nie wolno!			
			//if ( DropDownList4.SelectedItem != null )
			//	Response.Write( DropDownList4.SelectedValue );

			string[] values = Request.Form.GetValues( DropDownList4.ClientID );
			if ( values.Length == 1 )
				Response.Write( values[0] );
		}
	}
}
