using System;
using System.Collections.Generic;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ScriptingCallbacks : System.Web.UI.Page, ICallbackEventHandler
{
    protected override void Render( HtmlTextWriter writer )
    {
        base.Render( writer );
        this.ClientScript.RegisterForEventValidation( DropDownList2.ClientID );
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if ( !this.IsPostBack )
        {
            BindCountries();
        }

        string scriptref = this.ClientScript.GetCallbackEventReference( this, "document.all['DropDownList1'].value", "DropDown1Callback", "", true );
        DropDownList1.Attributes.Add( "onchange", scriptref );
    }

    void BindCountries()
    {
        DropDownList1.DataSource = Logic.GetCountries();
        DropDownList1.DataBind();
    }

    #region ICallbackEventHandler Members
    string argument;
    public string GetCallbackResult()
    {
        return Logic.GetCitiesCallback( argument );
    }

    public void RaiseCallbackEvent( string eventArgument )
    {
        this.argument = eventArgument;
    }
    #endregion
    protected void Button1_Click( object sender, EventArgs e )
    {
        Response.Write( Request.Form.GetValues( DropDownList2.ClientID )[0] );
    }
}
